/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.transport;

import co.codewizards.cloudstore.core.repo.transport.AbstractRepoTransportFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import co.codewizards.cloudstore.rest.client.transport.RestRepoTransport;
import java.net.URL;
import java.util.Objects;

public class RestRepoTransportFactory
extends AbstractRepoTransportFactory {
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_HTTP = "http";
    private volatile Class<? extends DynamicX509TrustManagerCallback> dynamicX509TrustManagerCallbackClass;

    public Class<? extends DynamicX509TrustManagerCallback> getDynamicX509TrustManagerCallbackClass() {
        return this.dynamicX509TrustManagerCallbackClass;
    }

    public void setDynamicX509TrustManagerCallbackClass(Class<? extends DynamicX509TrustManagerCallback> dynamicX509TrustManagerCallbackClass) {
        this.dynamicX509TrustManagerCallbackClass = dynamicX509TrustManagerCallbackClass;
    }

    public String getName() {
        return "REST";
    }

    public String getDescription() {
        return "Repository on a remote server accessible via REST";
    }

    public boolean isSupported(URL remoteRoot) {
        return PROTOCOL_HTTP.equals(Objects.requireNonNull(remoteRoot, "remoteRoot").getProtocol()) || PROTOCOL_HTTPS.equals(remoteRoot.getProtocol());
    }

    protected RepoTransport _createRepoTransport() {
        return new RestRepoTransport();
    }
}

