/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommand;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import java.util.Collection;
import java.util.UUID;

public class RepoListSubCommand
extends SubCommand {
    @Override
    public String getSubCommandDescription() {
        return "List all local repositories known to the registry.";
    }

    @Override
    public void run() throws Exception {
        LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
        System.out.println("Local repositories:");
        for (UUID repositoryId : localRepoRegistry.getRepositoryIds()) {
            File localRoot = localRepoRegistry.getLocalRoot(repositoryId);
            Collection repositoryAliases = localRepoRegistry.getRepositoryAliasesOrFail(repositoryId.toString());
            System.out.println(String.format("  * repository.repositoryId = %s", repositoryId));
            System.out.println(String.format("    repository.localRoot = %s", localRoot));
            System.out.println(String.format("    repository.aliases = %s", repositoryAliases));
            System.out.println();
        }
    }
}

