/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutConsoleReader {
    private final String question;
    private final long timeoutMsec;
    private final String timeoutAnswer;

    public TimeoutConsoleReader(String question, long timeoutMsec, String timeoutAnswer) {
        this.question = question;
        this.timeoutMsec = timeoutMsec;
        this.timeoutAnswer = timeoutAnswer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws InterruptedException {
        ExecutorService ex = Executors.newSingleThreadExecutor();
        String answer = null;
        try {
            Future<String> future = ex.submit(new CallableReader());
            try {
                System.out.println(this.question);
                answer = future.get(this.timeoutMsec, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
            }
            catch (TimeoutException e) {
                System.err.println(">>> The question was without reply, will cancel.");
                future.cancel(true);
                System.err.println(">>> Giving no answer will be interpreted as: " + this.timeoutAnswer);
                answer = this.timeoutAnswer;
            }
        }
        finally {
            ex.shutdownNow();
        }
        return answer;
    }

    private class CallableReader
    implements Callable<String> {
        private CallableReader() {
        }

        @Override
        public String call() throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String line = "";
            while ("".equals(line)) {
                try {
                    while (!br.ready()) {
                        Thread.sleep(200L);
                    }
                    line = br.readLine();
                }
                catch (InterruptedException e) {
                    System.err.println("CallableReader() interrupted!");
                    return TimeoutConsoleReader.this.timeoutAnswer;
                }
            }
            System.out.println("Your answer was: '" + line + "'");
            return line;
        }
    }
}

