/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.FileAlreadyRepositoryException;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseEvent;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerCloseListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerException;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.LocalRepoManagerImpl;
import co.codewizards.cloudstore.local.LocalRepoManagerInvocationHandler;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoManagerFactoryImpl
implements LocalRepoManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoManagerFactoryImpl.class);
    private final Map<File, LocalRepoManagerImpl> localRoot2LocalRepoManagerImpl = new HashMap<File, LocalRepoManagerImpl>();
    private final Set<LocalRepoManagerImpl> nonReOpenableLocalRepoManagerImpls = new HashSet<LocalRepoManagerImpl>();
    private final List<LocalRepoManagerCloseListener> localRepoManagerCloseListeners = new CopyOnWriteArrayList<LocalRepoManagerCloseListener>();
    private final LocalRepoManagerCloseListener localRepoManagerCloseListener = new LocalRepoManagerCloseListener(){

        public void preClose(LocalRepoManagerCloseEvent event) {
            if (!event.isBackend()) {
                throw new IllegalStateException("Why are we notified by the proxy?!?");
            }
            LocalRepoManagerFactoryImpl.this.preLocalRepoManagerBackendClose(event.getLocalRepoManager());
        }

        public void postClose(LocalRepoManagerCloseEvent event) {
            if (!event.isBackend()) {
                throw new IllegalStateException("Why are we notified by the proxy?!?");
            }
            LocalRepoManagerFactoryImpl.this.postLocalRepoManagerBackendClose((LocalRepoManagerImpl)event.getLocalRepoManager());
        }
    };

    public synchronized Set<File> getLocalRoots() {
        return Collections.unmodifiableSet(new HashSet<File>(this.localRoot2LocalRepoManagerImpl.keySet()));
    }

    public synchronized LocalRepoManager createLocalRepoManagerForExistingRepository(File localRoot) throws LocalRepoManagerException {
        LocalRepoManagerImpl localRepoManagerImpl = this.localRoot2LocalRepoManagerImpl.get(localRoot = this.canonicalize(localRoot));
        if (localRepoManagerImpl != null && !localRepoManagerImpl.open()) {
            this.localRoot2LocalRepoManagerImpl.remove(localRoot);
            this.nonReOpenableLocalRepoManagerImpls.add(localRepoManagerImpl);
            while (localRepoManagerImpl.isOpen()) {
                logger.info("createLocalRepoManagerForExistingRepository: Existing LocalRepoManagerImpl is currently closing and could not be re-opened. Waiting for it to be completely closed.");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException x) {
                    Util.doNothing();
                }
            }
            localRepoManagerImpl = null;
        }
        if (localRepoManagerImpl == null) {
            localRepoManagerImpl = new LocalRepoManagerImpl(localRoot, false);
            if (!localRepoManagerImpl.open()) {
                throw new IllegalStateException("localRepoManagerImpl.open() of *new* instance returned false!");
            }
            this.enlist(localRepoManagerImpl);
        }
        return this.createProxy(localRepoManagerImpl);
    }

    public synchronized LocalRepoManager createLocalRepoManagerForNewRepository(File localRoot) throws LocalRepoManagerException {
        LocalRepoManagerImpl localRepoManagerImpl = this.localRoot2LocalRepoManagerImpl.get(localRoot = this.canonicalize(localRoot));
        if (localRepoManagerImpl != null) {
            throw new FileAlreadyRepositoryException(localRoot);
        }
        localRepoManagerImpl = new LocalRepoManagerImpl(localRoot, true);
        if (!localRepoManagerImpl.open()) {
            throw new IllegalStateException("localRepoManagerImpl.open() of *new* instance returned false!");
        }
        this.enlist(localRepoManagerImpl);
        return this.createProxy(localRepoManagerImpl);
    }

    private LocalRepoManager createProxy(LocalRepoManagerImpl localRepoManagerImpl) {
        return (LocalRepoManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LocalRepoManager.class}, (InvocationHandler)new LocalRepoManagerInvocationHandler(localRepoManagerImpl));
    }

    public synchronized void close() {
        for (LocalRepoManagerImpl localRepoManagerImpl : new ArrayList<LocalRepoManagerImpl>(this.localRoot2LocalRepoManagerImpl.values())) {
            localRepoManagerImpl.close();
        }
    }

    public void addLocalRepoManagerCloseListener(LocalRepoManagerCloseListener listener) {
        this.localRepoManagerCloseListeners.add(listener);
    }

    public void removeLocalRepoManagerCloseListener(LocalRepoManagerCloseListener listener) {
        this.localRepoManagerCloseListeners.remove(listener);
    }

    private void enlist(LocalRepoManagerImpl localRepoManager) {
        this.localRoot2LocalRepoManagerImpl.put(localRepoManager.getLocalRoot(), localRepoManager);
        localRepoManager.addLocalRepoManagerCloseListener(this.localRepoManagerCloseListener);
    }

    private File canonicalize(File localRoot) {
        Objects.requireNonNull(localRoot, "localRoot");
        try {
            localRoot = localRoot.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return localRoot;
    }

    private void preLocalRepoManagerBackendClose(LocalRepoManager localRepoManager) {
        LocalRepoManagerCloseEvent event = new LocalRepoManagerCloseEvent((Object)this, localRepoManager, true);
        for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
            listener.preClose(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postLocalRepoManagerBackendClose(LocalRepoManagerImpl localRepoManager) {
        Objects.requireNonNull(localRepoManager, "localRepoManager");
        LocalRepoManagerFactoryImpl localRepoManagerFactoryImpl = this;
        synchronized (localRepoManagerFactoryImpl) {
            LocalRepoManagerImpl localRepoManager2 = this.localRoot2LocalRepoManagerImpl.remove(localRepoManager.getLocalRoot());
            if (localRepoManager != localRepoManager2) {
                if (!this.nonReOpenableLocalRepoManagerImpls.remove(localRepoManager)) {
                    throw new IllegalStateException(String.format("localRepoManager[%s] is unknown!", localRepoManager.id));
                }
                logger.info("localRepoManager[{}] could not be re-opened and was unlisted before.", (Object)localRepoManager.id);
                this.localRoot2LocalRepoManagerImpl.put(localRepoManager2.getLocalRoot(), localRepoManager2);
            }
        }
        LocalRepoManagerCloseEvent event = new LocalRepoManagerCloseEvent((Object)this, (LocalRepoManager)localRepoManager, true);
        for (LocalRepoManagerCloseListener listener : this.localRepoManagerCloseListeners) {
            listener.postClose(event);
        }
    }
}

