/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.auth.SignedAuthToken;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;

public class AuthTokenVerifier {
    private PublicKey publicKey;

    public AuthTokenVerifier(byte[] publicKeyData) {
        Objects.requireNonNull(publicKeyData, "publicKeyData");
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyData);
            this.publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void verify(SignedAuthToken signedAuthToken) {
        Objects.requireNonNull(signedAuthToken, "signedAuthToken");
        Objects.requireNonNull(signedAuthToken.getAuthTokenData(), "signedAuthToken.authTokenData");
        Objects.requireNonNull(signedAuthToken.getSignature(), "signedAuthToken.signature");
        try {
            Signature verificationEngine = Signature.getInstance("SHA256withRSA");
            verificationEngine.initVerify(this.publicKey);
            verificationEngine.update(signedAuthToken.getAuthTokenData());
            if (!verificationEngine.verify(signedAuthToken.getSignature())) {
                throw new SignatureException("Signature not valid.");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

