/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.collection;

import co.codewizards.cloudstore.core.util.Util;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class ReverseListView<E>
implements List<E> {
    private final List<E> list;

    public ReverseListView(List<E> list) {
        this.list = Objects.requireNonNull(list, "list");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.list.size()) {
            a = (Object[])Array.newInstance(a.getClass(), this.list.size());
        }
        int index = -1;
        for (E e : this) {
            a[++index] = e;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        this.list.add(0, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        for (E e : c) {
            this.add(index++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List other = (List)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<E> thisIterator = this.iterator();
        Iterator otherIterator = other.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Object otherElement;
            E thisElement = thisIterator.next();
            if (Util.equal(thisElement, otherElement = otherIterator.next())) continue;
            return false;
        }
        return thisIterator.hasNext() == otherIterator.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public E get(int index) {
        return this.list.get(this.translateIndex(index));
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(this.translateIndex(index), element);
    }

    @Override
    public void add(int index, E element) {
        this.list.add(this.translateIndex(index), element);
    }

    private int translateIndex(int index) {
        return this.list.size() - index - 1;
    }

    @Override
    public E remove(int index) {
        return this.list.remove(this.translateIndex(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.translateIndex(this.list.lastIndexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.translateIndex(this.list.indexOf(o));
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            private final ListIterator<E> listIter;
            {
                this.listIter = ReverseListView.this.list.listIterator(ReverseListView.this.translateIndex(index) + 1);
            }

            @Override
            public boolean hasNext() {
                return this.listIter.hasPrevious();
            }

            @Override
            public E next() {
                return this.listIter.previous();
            }

            @Override
            public void remove() {
                this.listIter.remove();
            }

            @Override
            public boolean hasPrevious() {
                return this.listIter.hasNext();
            }

            @Override
            public E previous() {
                return this.listIter.next();
            }

            @Override
            public int nextIndex() {
                return this.listIter.previousIndex();
            }

            @Override
            public int previousIndex() {
                return this.listIter.nextIndex();
            }

            @Override
            public void set(E e) {
                this.listIter.set(e);
            }

            @Override
            public void add(E e) {
                this.listIter.add(e);
                if (e != this.next()) {
                    throw new IllegalStateException("WTF?!");
                }
            }
        };
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ReverseListView<E>(this.list.subList(this.translateIndex(toIndex), this.translateIndex(fromIndex)));
    }

    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this || e == this.list ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

