/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.updater;

import co.codewizards.cloudstore.core.DevMode;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import co.codewizards.cloudstore.core.version.LocalVersionInIdeHelper;
import co.codewizards.cloudstore.core.version.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreUpdaterCore {
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreUpdaterCore.class);
    public static final String INSTALLATION_PROPERTIES_FILE_NAME = "installation.properties";
    public static final String INSTALLATION_PROPERTIES_ARTIFACT_ID = "artifactId";
    public static final String INSTALLATION_PROPERTIES_VERSION = "version";
    public static final String remoteVersionURL = AppIdRegistry.getInstance().getAppIdOrFail().getWebSiteBaseUrl() + "update/${artifactId}/version";
    public static final String remoteUpdatePropertiesURL = AppIdRegistry.getInstance().getAppIdOrFail().getWebSiteBaseUrl() + "update/${artifactId}/update.0.properties";
    public static final String CONFIG_KEY_DOWNGRADE = "updater.downgrade";
    public static final String CONFIG_KEY_ENABLED = "updater.enabled";
    public static final String CONFIG_KEY_FORCE = "updater.force";
    public static final long DEFAULT_REMOTE_VERSION_CACHE_VALIDITY_PERIOD = 21600000L;
    public static final String CONFIG_KEY_REMOTE_VERSION_CACHE_VALIDITY_PERIOD = "updater.remoteVersionCache.validityPeriod";
    private Version localVersion;
    private Version remoteVersion;
    private Properties installationProperties;
    private co.codewizards.cloudstore.core.oio.File installationDir;
    private co.codewizards.cloudstore.core.oio.File updaterDir;
    private co.codewizards.cloudstore.core.oio.File backupDir;
    private static final String PROPERTY_KEY_REMOTE_VERSION_TIMESTAMP = "remoteVersionTimestamp";
    private static final String PROPERTY_KEY_REMOTE_VERSION = "remoteVersion";
    protected final FileFilter fileFilterIgnoringBackupDir = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !CloudStoreUpdaterCore.this.getBackupDir().getIoFile().equals(file);
        }
    };
    protected final FileFilter fileFilterIgnoringBackupAndUpdaterDir = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !CloudStoreUpdaterCore.this.getBackupDir().getIoFile().equals(file) && !CloudStoreUpdaterCore.this.getUpdaterDir().getIoFile().equals(file);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getRemoteVersion() {
        Version remoteVersion = this.remoteVersion;
        if (remoteVersion == null) {
            RemoteVersionCache remoteVersionCache = this.readRemoteVersionCacheFromProperties();
            long cachePeriod = this.getRemoteVersionCacheValidityPeriod();
            if (remoteVersionCache != null && System.currentTimeMillis() - remoteVersionCache.remoteVersionTimestamp.getMillis() <= cachePeriod) {
                logger.debug("getRemoteVersion: Cached value '{}' is from {} and still valid (it expires {}). Using this value (not asking server).", new Object[]{remoteVersionCache.remoteVersion, remoteVersionCache.remoteVersionTimestamp.toDate(), new Date(remoteVersionCache.remoteVersionTimestamp.getMillis() + cachePeriod)});
                this.remoteVersion = remoteVersion = remoteVersionCache.remoteVersion;
            } else {
                String artifactId = this.getInstallationProperties().getProperty(INSTALLATION_PROPERTIES_ARTIFACT_ID);
                Objects.requireNonNull(artifactId, INSTALLATION_PROPERTIES_ARTIFACT_ID);
                HashMap<String, String> variables = new HashMap<String, String>(1);
                variables.put(INSTALLATION_PROPERTIES_ARTIFACT_ID, artifactId);
                String resolvedRemoteVersionURL = IOUtil.replaceTemplateVariables(remoteVersionURL, variables);
                try {
                    URL url = new URL(resolvedRemoteVersionURL);
                    try (InputStream in = url.openStream();){
                        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                        String line = r.readLine();
                        if (line == null || line.isEmpty()) {
                            throw new IllegalStateException("Failed to read version from: " + resolvedRemoteVersionURL);
                        }
                        String trimmed = line.trim();
                        if (trimmed.isEmpty()) {
                            throw new IllegalStateException("Failed to read version from: " + resolvedRemoteVersionURL);
                        }
                        this.remoteVersion = remoteVersion = new Version(trimmed);
                        r.close();
                    }
                    this.writeRemoteVersionCacheToProperties(new RemoteVersionCache(remoteVersion, new DateTime(new Date())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return remoteVersion;
    }

    public Version getLocalVersion() {
        if (this.localVersion == null) {
            Properties installationProperties = null;
            try {
                installationProperties = this.getInstallationProperties();
            }
            catch (UnsupportedOperationException x) {
                this.localVersion = LocalVersionInIdeHelper.getInstance().getLocalVersionInIde();
            }
            if (this.localVersion == null) {
                String value = installationProperties.getProperty(INSTALLATION_PROPERTIES_VERSION);
                if (value == null || value.isEmpty()) {
                    throw new IllegalStateException("Failed to read local version from installation-properties-file!");
                }
                String trimmed = value.trim();
                if (trimmed.isEmpty()) {
                    throw new IllegalStateException("Failed to read local version from installation-properties-file!");
                }
                this.localVersion = new Version(trimmed);
            }
        }
        return this.localVersion;
    }

    protected Properties getInstallationProperties() {
        if (this.installationProperties == null) {
            co.codewizards.cloudstore.core.oio.File installationPropertiesFile = OioFileFactory.createFile(this.getInstallationDir(), INSTALLATION_PROPERTIES_FILE_NAME);
            if (!installationPropertiesFile.exists()) {
                throw new IllegalArgumentException(String.format("installationPropertiesFile '%s' does not exist!", installationPropertiesFile.getAbsolutePath()));
            }
            if (!installationPropertiesFile.isFile()) {
                throw new IllegalArgumentException(String.format("installationPropertiesFile '%s' is not a file!", installationPropertiesFile.getAbsolutePath()));
            }
            try {
                Properties properties;
                this.installationProperties = properties = PropertiesUtil.load(installationPropertiesFile);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        return this.installationProperties;
    }

    protected String resolve(String template) {
        Objects.requireNonNull(template, "template");
        String artifactId = this.getInstallationProperties().getProperty(INSTALLATION_PROPERTIES_ARTIFACT_ID);
        Objects.requireNonNull(artifactId, INSTALLATION_PROPERTIES_ARTIFACT_ID);
        Version remoteVersion = this.getRemoteVersion();
        HashMap<String, Object> variables = new HashMap<String, Object>(4);
        variables.put(INSTALLATION_PROPERTIES_ARTIFACT_ID, artifactId);
        variables.put(INSTALLATION_PROPERTIES_VERSION, remoteVersion);
        variables.put(PROPERTY_KEY_REMOTE_VERSION, remoteVersion);
        variables.put("localVersion", this.getLocalVersion());
        return IOUtil.replaceTemplateVariables(template, variables);
    }

    protected co.codewizards.cloudstore.core.oio.File getInstallationDir() throws IllegalStateException {
        if (this.installationDir == null) {
            this.installationDir = this.determineInstallationDirFromClass();
        }
        return this.installationDir;
    }

    private co.codewizards.cloudstore.core.oio.File determineInstallationDirFromClass() {
        if (DevMode.isDevModeEnabled()) {
            throw new UnsupportedOperationException("There is no installationDir in DevMode!");
        }
        URL resource = CloudStoreUpdaterCore.class.getResource("");
        logger.debug("determineInstallationDirFromClass: resource={}", (Object)resource);
        if (resource.getProtocol().equalsIgnoreCase("jar")) {
            co.codewizards.cloudstore.core.oio.File file = UrlUtil.getFileFromJarUrl(resource);
            logger.debug("determineInstallationDirFromClass: file={}", (Object)file);
            co.codewizards.cloudstore.core.oio.File dir = file;
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            while (dir != null) {
                co.codewizards.cloudstore.core.oio.File installationPropertiesFile = OioFileFactory.createFile(dir, INSTALLATION_PROPERTIES_FILE_NAME);
                if (installationPropertiesFile.exists()) {
                    logger.debug("determineInstallationDirFromClass: Found installationPropertiesFile in this directory: {}", (Object)dir);
                    return dir;
                }
                logger.debug("determineInstallationDirFromClass: installationPropertiesFile not found in this directory: {}", (Object)dir);
                dir = dir.getParentFile();
            }
            throw new IllegalStateException(String.format("File '%s' was not found in any expected location!", INSTALLATION_PROPERTIES_FILE_NAME));
        }
        if (resource.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalStateException("CloudStoreUpdaterCore was loaded inside the IDE! Load it from a real installation!");
        }
        throw new IllegalStateException("Class 'CloudStoreUpdaterCore' was not loaded from a local JAR or class file!");
    }

    private boolean isDowngrade() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_DOWNGRADE, Boolean.FALSE);
    }

    private boolean isForce() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_FORCE, Boolean.FALSE);
    }

    private boolean isEnabled() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_ENABLED, Boolean.TRUE);
    }

    private long getRemoteVersionCacheValidityPeriod() {
        return ConfigImpl.getInstance().getPropertyAsPositiveOrZeroLong(CONFIG_KEY_REMOTE_VERSION_CACHE_VALIDITY_PERIOD, 21600000L);
    }

    private co.codewizards.cloudstore.core.oio.File getUpdaterPropertiesFile() {
        return OioFileFactory.createFile(ConfigDir.getInstance().getFile(), "updater.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteVersionCache readRemoteVersionCacheFromProperties() {
        Throwable throwable = null;
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getUpdaterPropertiesFile(), 30000L);){
            DateTime remoteVersionTimestamp;
            Version remoteVersion;
            String timestampStr;
            String versionStr;
            block42: {
                Properties properties = new Properties();
                try {
                    try (InputStream in = StreamUtil.castStream(lockFile.createInputStream());){
                        properties.load(in);
                    }
                    versionStr = properties.getProperty(PROPERTY_KEY_REMOTE_VERSION);
                    if (versionStr == null || versionStr.trim().isEmpty()) {
                        RemoteVersionCache remoteVersionCache = null;
                        return remoteVersionCache;
                    }
                    timestampStr = properties.getProperty(PROPERTY_KEY_REMOTE_VERSION_TIMESTAMP);
                    if (timestampStr != null && !timestampStr.trim().isEmpty()) break block42;
                    RemoteVersionCache remoteVersionCache = null;
                    return remoteVersionCache;
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            try {
                remoteVersion = new Version(versionStr.trim());
            }
            catch (Exception x) {
                logger.warn("readRemoteVersionFromProperties: Version-String '{}' could not be parsed into a Version! Returning null!", (Object)versionStr.trim());
                RemoteVersionCache remoteVersionCache = null;
                if (lockFile != null) {
                    if (throwable != null) {
                        try {
                            lockFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        lockFile.close();
                    }
                }
                return remoteVersionCache;
            }
            try {
                remoteVersionTimestamp = new DateTime(timestampStr.trim());
            }
            catch (Exception x) {
                logger.warn("readRemoteVersionFromProperties: Timestamp-String '{}' could not be parsed into a DateTime! Returning null!", (Object)timestampStr.trim());
                RemoteVersionCache remoteVersionCache = null;
                if (lockFile != null) {
                    if (throwable != null) {
                        try {
                            lockFile.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        lockFile.close();
                    }
                }
                return remoteVersionCache;
            }
            RemoteVersionCache remoteVersionCache = new RemoteVersionCache(remoteVersion, remoteVersionTimestamp);
            return remoteVersionCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRemoteVersionCacheToProperties(RemoteVersionCache remoteVersionCache) {
        try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getUpdaterPropertiesFile(), 30000L);){
            Lock lock = lockFile.getLock();
            lock.lock();
            try {
                Properties properties = new Properties();
                try {
                    try (InputStream in = StreamUtil.castStream(lockFile.createInputStream());){
                        properties.load(in);
                    }
                    if (remoteVersionCache == null) {
                        properties.remove(PROPERTY_KEY_REMOTE_VERSION);
                        properties.remove(PROPERTY_KEY_REMOTE_VERSION_TIMESTAMP);
                    } else {
                        properties.setProperty(PROPERTY_KEY_REMOTE_VERSION, remoteVersionCache.remoteVersion.toString());
                        properties.setProperty(PROPERTY_KEY_REMOTE_VERSION_TIMESTAMP, remoteVersionCache.remoteVersionTimestamp.toString());
                    }
                    try (OutputStream out = StreamUtil.castStream(lockFile.createOutputStream());){
                        properties.store(out, null);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public boolean createUpdaterDirIfUpdateNeeded() {
        block9: {
            co.codewizards.cloudstore.core.oio.File updaterDir = null;
            try {
                if (!this.isEnabled()) {
                    if (this.isForce()) {
                        logger.warn("createUpdaterDirIfUpdateNeeded: The configuration key '{}' (or its corresponding system property) is set to force an update, but the updater is *not* enabled! You must set the configuration key '{}' (or its corresponding system property) additionally! Skipping!", (Object)CONFIG_KEY_FORCE, (Object)CONFIG_KEY_ENABLED);
                    } else {
                        logger.info("createUpdaterDirIfUpdateNeeded: Updater is *not* enabled! Skipping! See configuration key '{}'.", (Object)CONFIG_KEY_ENABLED);
                    }
                    return false;
                }
                updaterDir = this.getUpdaterDir();
                IOUtil.deleteDirectoryRecursively(updaterDir);
                if (this.isUpdateNeeded()) {
                    if (!this.canWriteAll(this.getInstallationDir())) {
                        logger.error("Installation directory '{}' is not writable or contains sub-directories/files that are not writable! Cannot perform auto-update to new version {}! Please update manually! Your local version is {}.", new Object[]{this.getInstallationDir(), this.getRemoteVersion(), this.getLocalVersion()});
                        return false;
                    }
                    this.copyInstallationDirectoryForUpdater();
                    logger.debug("createUpdaterDirIfUpdateNeeded: updaterDir='{}'", (Object)updaterDir);
                    return true;
                }
            }
            catch (Exception x) {
                logger.error("createUpdaterDirIfUpdateNeeded: " + x, (Throwable)x);
                if (updaterDir == null) break block9;
                try {
                    IOUtil.deleteDirectoryRecursively(updaterDir);
                }
                catch (Exception y) {
                    logger.error("createUpdaterDirIfUpdateNeeded: " + y, (Throwable)y);
                }
            }
        }
        return false;
    }

    private boolean canWriteAll(co.codewizards.cloudstore.core.oio.File fileOrDir) {
        if (!fileOrDir.canWrite()) {
            return false;
        }
        co.codewizards.cloudstore.core.oio.File[] children = fileOrDir.listFiles(this.fileFilterIgnoringBackupDir);
        if (children != null) {
            for (co.codewizards.cloudstore.core.oio.File child : children) {
                if (this.canWriteAll(child)) continue;
                return false;
            }
        }
        return true;
    }

    public co.codewizards.cloudstore.core.oio.File getUpdaterDir() {
        if (this.updaterDir == null) {
            this.updaterDir = OioFileFactory.createFile(this.getInstallationDir(), "updater");
        }
        return this.updaterDir;
    }

    protected co.codewizards.cloudstore.core.oio.File getBackupDir() {
        if (this.backupDir == null) {
            this.backupDir = OioFileFactory.createFile(this.getInstallationDir(), "backup");
        }
        return this.backupDir;
    }

    private co.codewizards.cloudstore.core.oio.File copyInstallationDirectoryForUpdater() {
        try {
            co.codewizards.cloudstore.core.oio.File updaterDir = this.getUpdaterDir();
            IOUtil.deleteDirectoryRecursively(updaterDir);
            IOUtil.copyDirectory(this.getInstallationDir(), updaterDir, this.fileFilterIgnoringBackupAndUpdaterDir);
            return updaterDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isUpdateNeeded() {
        Version localVersion = this.getLocalVersion();
        Version remoteVersion = this.getRemoteVersion();
        if (this.isForce()) {
            logger.warn("isUpdateNeeded: Update forced via system-property! localVersion='{}' remoteVersion='{}'", (Object)localVersion, (Object)remoteVersion);
            return true;
        }
        if (localVersion.equals(remoteVersion)) {
            logger.debug("isUpdateNeeded: No update, because localVersion equals remoteVersion='{}'", (Object)remoteVersion);
            return false;
        }
        if (localVersion.compareTo(remoteVersion) > 0) {
            if (this.isDowngrade()) {
                logger.warn("isUpdateNeeded: Downgrading enabled via system-property! localVersion='{}' remoteVersion='{}'", (Object)localVersion, (Object)remoteVersion);
                return true;
            }
            logger.info("isUpdateNeeded: No update, because localVersion='{}' is newer than remoteVersion='{}'", (Object)localVersion, (Object)remoteVersion);
            return false;
        }
        logger.warn("isUpdateNeeded: Update needed! localVersion='{}' remoteVersion='{}'", (Object)localVersion, (Object)remoteVersion);
        return true;
    }

    private static class RemoteVersionCache {
        public final Version remoteVersion;
        public final DateTime remoteVersionTimestamp;

        public RemoteVersionCache(Version remoteVersion, DateTime remoteVersionTimestamp) {
            this.remoteVersion = Objects.requireNonNull(remoteVersion, CloudStoreUpdaterCore.PROPERTY_KEY_REMOTE_VERSION);
            this.remoteVersionTimestamp = Objects.requireNonNull(remoteVersionTimestamp, CloudStoreUpdaterCore.PROPERTY_KEY_REMOTE_VERSION_TIMESTAMP);
        }
    }
}

