/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util;

import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);
    public static final String SUFFIX_NULL_VALUE = ".null";
    private static final Pattern validSystemPropertyKeyPattern = Pattern.compile("[a-zA-Z_]+[a-zA-Z0-9_\\.\\[\\]]*");

    private PropertiesUtil() {
    }

    public static Collection<Matcher> getPropertyKeyMatches(Properties properties, Pattern pattern) {
        ArrayList<Matcher> matches = new ArrayList<Matcher>();
        for (Object element : properties.keySet()) {
            String key = (String)element;
            Matcher m = pattern.matcher(key);
            if (!m.matches()) continue;
            matches.add(m);
        }
        return matches;
    }

    public static Properties getProperties(Properties properties, String keyPrefix) {
        Properties newProperties = new Properties();
        Collection<Matcher> matches = PropertiesUtil.getPropertyKeyMatches(properties, Pattern.compile("^" + Pattern.quote(keyPrefix) + "(.*)$"));
        for (Matcher m : matches) {
            newProperties.put(m.group(1), properties.get(m.group(0)));
        }
        return newProperties;
    }

    public static void putAll(Properties source, Properties target) {
        for (Object element : source.keySet()) {
            String key = (String)element;
            target.setProperty(key, source.getProperty(key));
        }
    }

    public static Properties load(String filename) throws IOException {
        return PropertiesUtil.load(filename != null ? OioFileFactory.createFile(filename) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(File file) throws IOException {
        try (InputStream in = StreamUtil.castStream(file.createInputStream());){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static void store(String filename, Properties properties, String comment) throws IOException {
        PropertiesUtil.store(filename != null ? OioFileFactory.createFile(filename) : null, properties, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(File file, Properties properties, String comment) throws IOException {
        try (OutputStream out = StreamUtil.castStream(file.createOutputStream());){
            properties.store(out, comment);
        }
    }

    public static Map<String, String> filterProperties(Map<?, ?> rawProperties) {
        return PropertiesUtil.filterProperties(rawProperties, null);
    }

    public static Map<String, String> filterProperties(Map<?, ?> rawProperties, Map<?, ?> variables) {
        if (rawProperties == null) {
            throw new IllegalArgumentException("rawProperties == null");
        }
        HashMap<String, String> filteredProperties = new HashMap<String, String>();
        for (Map.Entry<?, ?> me : rawProperties.entrySet()) {
            String value;
            String key = me.getKey() == null ? null : me.getKey().toString();
            String string = value = me.getValue() == null ? null : me.getValue().toString();
            if (PropertiesUtil.isMetaPropertyKey(key)) {
                if (!PropertiesUtil.isMetaPropertyKeyNullValue(key) || !Boolean.parseBoolean(value)) continue;
                String refKey = PropertiesUtil.getReferencedPropertyKeyForMetaPropertyKey(key);
                filteredProperties.put(refKey, null);
                continue;
            }
            if (value != null && PropertiesUtil.isNullValue(rawProperties, key)) {
                value = null;
            }
            if (value != null && variables != null) {
                value = IOUtil.replaceTemplateVariables(value, variables);
            }
            filteredProperties.put(key, value);
        }
        return filteredProperties;
    }

    public static boolean isMetaPropertyKeyNullValue(String key) {
        if (key == null) {
            return false;
        }
        return key.endsWith(SUFFIX_NULL_VALUE);
    }

    public static boolean isMetaPropertyKey(String key) {
        return PropertiesUtil.isMetaPropertyKeyNullValue(key);
    }

    public static String getReferencedPropertyKeyForMetaPropertyKey(String key) {
        if (!PropertiesUtil.isMetaPropertyKeyNullValue(key)) {
            throw new IllegalArgumentException("key='" + key + "' is not a meta-property!");
        }
        return key.substring(0, key.length() - SUFFIX_NULL_VALUE.length());
    }

    public static String getMetaPropertyKeyNullValue(String key) {
        if (key == null) {
            key = String.valueOf(key);
        }
        if (PropertiesUtil.isMetaPropertyKeyNullValue(key)) {
            throw new IllegalArgumentException("key='" + key + "' is already a meta-property indicating a null-value!");
        }
        return key + SUFFIX_NULL_VALUE;
    }

    public static boolean isNullValue(Map<?, ?> properties, String key) {
        if (properties == null) {
            throw new IllegalArgumentException("properties == null");
        }
        if (properties.get(key) == null) {
            return true;
        }
        if (PropertiesUtil.isMetaPropertyKeyNullValue(key)) {
            return false;
        }
        String metaNullValue = String.valueOf(properties.get(PropertiesUtil.getMetaPropertyKeyNullValue(key)));
        return Boolean.parseBoolean(metaNullValue);
    }

    public static int getSystemPropertyValueAsInt(String key, int defaultValue) {
        long value = PropertiesUtil.getSystemPropertyValueAsLong(key, defaultValue);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            logger.warn("System property '{}' is set to the value '{}' which is out of range for a 32-bit integer. Falling back to default value {}.", new Object[]{key, value, defaultValue});
            return defaultValue;
        }
        return (int)value;
    }

    public static long getSystemPropertyValueAsLong(String key, long defaultValue) {
        return PropertiesUtil.getPropertyValueAsLong(System.getProperties(), key, defaultValue);
    }

    public static long getPropertyValueAsLong(Properties properties, String key, long defaultValue) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(key, "key");
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException x) {
            return defaultValue;
        }
    }

    public static String systemPropertyToEnvironmentVariable(String key) {
        Objects.requireNonNull(key, "key");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is an empty string! At least one character is required!");
        }
        if (!validSystemPropertyKeyPattern.matcher(key).matches()) {
            if (Character.isDigit(key.charAt(0))) {
                throw new IllegalArgumentException("key must not start with a digit: " + key);
            }
            throw new IllegalArgumentException("key is not valid according to pattern: " + key);
        }
        return key.replace('.', '_').replace('[', '_').replace(']', '_');
    }
}

