/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommandWithExistingLocalRepo;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.ls.core.dto.RemoteRepositoryDto;
import co.codewizards.cloudstore.ls.core.dto.RemoteRepositoryRequestDto;
import co.codewizards.cloudstore.ls.core.dto.RepoInfoRequestDto;
import co.codewizards.cloudstore.ls.core.dto.RepoInfoResponseDto;
import co.codewizards.cloudstore.ls.rest.client.request.RepoInfoRequest;
import co.codewizards.cloudstore.ls.rest.client.request.Request;
import java.util.Objects;

public class RepoInfoSubCommand
extends SubCommandWithExistingLocalRepo {
    public RepoInfoSubCommand() {
    }

    protected RepoInfoSubCommand(File localRoot) {
        this.localFile = this.localRoot = Objects.requireNonNull(localRoot, "localRoot");
        this.local = localRoot.getPath();
    }

    @Override
    public String getSubCommandDescription() {
        return "Show information about an existing repository.";
    }

    @Override
    public void run() throws Exception {
        RepoInfoRequestDto repoInfoRequestDto = new RepoInfoRequestDto();
        repoInfoRequestDto.setLocalRoot(this.localRoot.getAbsolutePath());
        RepoInfoResponseDto repoInfoResponseDto = (RepoInfoResponseDto)this.getLocalServerRestClient().execute((Request)new RepoInfoRequest(repoInfoRequestDto));
        this.showMainProperties(repoInfoResponseDto);
        this.showRemoteRepositories(repoInfoResponseDto);
        this.showRemoteRepositoryRequests(repoInfoResponseDto);
        this.showRepositoryStats(repoInfoResponseDto);
    }

    private void showMainProperties(RepoInfoResponseDto repoInfoResponseDto) {
        System.out.println("Local repository:");
        System.out.println("  repository.repositoryId = " + repoInfoResponseDto.getRepositoryId());
        System.out.println("  repository.localRoot = " + repoInfoResponseDto.getLocalRoot());
        System.out.println("  repository.aliases = " + repoInfoResponseDto);
        System.out.println("  repository.publicKeySha1 = " + HashUtil.sha1ForHuman((byte[])repoInfoResponseDto.getPublicKey()));
        System.out.println();
    }

    private void showRemoteRepositories(RepoInfoResponseDto repoInfoResponseDto) {
        if (repoInfoResponseDto.getRemoteRepositoryDtos().isEmpty()) {
            System.out.println("Remote repositories connected: {NONE}");
            System.out.println();
        } else {
            System.out.println("Remote repositories connected:");
            for (RemoteRepositoryDto remoteRepositoryDto : repoInfoResponseDto.getRemoteRepositoryDtos()) {
                System.out.println("  * remoteRepository.repositoryId = " + remoteRepositoryDto.getRepositoryId());
                if (remoteRepositoryDto.getRemoteRoot() != null) {
                    System.out.println("    remoteRepository.remoteRoot = " + remoteRepositoryDto.getRemoteRoot());
                }
                System.out.println("    remoteRepository.publicKeySha1 = " + HashUtil.sha1ForHuman((byte[])remoteRepositoryDto.getPublicKey()));
                System.out.println();
            }
        }
    }

    private void showRemoteRepositoryRequests(RepoInfoResponseDto repoInfoResponseDto) {
        if (repoInfoResponseDto.getRemoteRepositoryRequestDtos().isEmpty()) {
            System.out.println("Remote repositories requesting connection: {NONE}");
            System.out.println();
        } else {
            System.out.println("Remote repositories requesting connection:");
            for (RemoteRepositoryRequestDto remoteRepositoryRequestDto : repoInfoResponseDto.getRemoteRepositoryRequestDtos()) {
                System.out.println("  * remoteRepositoryRequest.repositoryId = " + remoteRepositoryRequestDto.getRepositoryId());
                System.out.println("    remoteRepositoryRequest.publicKeySha1 = " + HashUtil.sha1ForHuman((byte[])remoteRepositoryRequestDto.getPublicKey()));
                System.out.println("    remoteRepositoryRequest.created = " + new DateTime(remoteRepositoryRequestDto.getCreated()));
                System.out.println("    remoteRepositoryRequest.changed = " + new DateTime(remoteRepositoryRequestDto.getChanged()));
                System.out.println();
            }
        }
    }

    private void showRepositoryStats(RepoInfoResponseDto repoInfoResponseDto) {
        System.out.println("Statistics:");
        System.out.println("  * Count(NormalFile): " + repoInfoResponseDto.getNormalFileCount());
        System.out.println("  * Count(Directory): " + repoInfoResponseDto.getDirectoryCount());
        System.out.println("  * Count(CopyModification): " + repoInfoResponseDto.getCopyModificationCount());
        System.out.println("  * Count(DeleteModification): " + repoInfoResponseDto.getDeleteModificationCount());
        System.out.println();
    }
}

