/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.ignore.IgnoreRuleManagerImpl;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.progress.SubProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.FilenameFilterSkipMetaDir;
import co.codewizards.cloudstore.local.LocalRepoTransactionImpl;
import co.codewizards.cloudstore.local.persistence.CopyModification;
import co.codewizards.cloudstore.local.persistence.DeleteModification;
import co.codewizards.cloudstore.local.persistence.DeleteModificationDao;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.FileChunk;
import co.codewizards.cloudstore.local.persistence.ModificationDao;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.NormalFileDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import co.codewizards.cloudstore.local.persistence.Symlink;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jdo.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepoSync {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoSync.class);
    protected final LocalRepoTransaction transaction;
    protected final File localRoot;
    protected final RepoFileDao repoFileDao;
    protected final NormalFileDao normalFileDao;
    protected final RemoteRepositoryDao remoteRepositoryDao;
    protected final ModificationDao modificationDao;
    protected final DeleteModificationDao deleteModificationDao;
    private Collection<RemoteRepository> remoteRepositories;
    private boolean ignoreRulesEnabled;
    private final Map<String, Set<String>> sha1AndLength2Paths = new HashMap<String, Set<String>>();

    protected LocalRepoSync(LocalRepoTransaction transaction) {
        this.transaction = Objects.requireNonNull(transaction, "transaction");
        this.localRoot = this.transaction.getLocalRepoManager().getLocalRoot();
        this.repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
        this.normalFileDao = (NormalFileDao)this.transaction.getDao(NormalFileDao.class);
        this.remoteRepositoryDao = (RemoteRepositoryDao)this.transaction.getDao(RemoteRepositoryDao.class);
        this.modificationDao = (ModificationDao)this.transaction.getDao(ModificationDao.class);
        this.deleteModificationDao = (DeleteModificationDao)this.transaction.getDao(DeleteModificationDao.class);
    }

    public static LocalRepoSync create(LocalRepoTransaction transaction) {
        return (LocalRepoSync)ObjectFactoryUtil.createObject(LocalRepoSync.class, (Object[])new Object[]{transaction});
    }

    public void sync(ProgressMonitor monitor) {
        this.sync(null, this.localRoot, monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepoFile sync(File file, ProgressMonitor monitor, boolean recursiveChildren) {
        if (!Objects.requireNonNull(file, "file").isAbsolute()) {
            throw new IllegalArgumentException("file is not absolute: " + file);
        }
        if (this.localRoot.equals(file)) {
            return this.sync(null, file, monitor, recursiveChildren);
        }
        monitor.beginTask("Local sync...", 100);
        try {
            File parentFile = file.getParentFile();
            RepoFile parentRepoFile = this.repoFileDao.getRepoFile(this.localRoot, parentFile);
            if (parentRepoFile == null) {
                if (!file.isSymbolicLink() && !file.exists() && this.repoFileDao.getRepoFile(this.localRoot, file) == null) {
                    RepoFile repoFile = null;
                    return repoFile;
                }
                this.sync(null, this.localRoot, (ProgressMonitor)new SubProgressMonitor(monitor, 99), true);
                RepoFile repoFile = this.repoFileDao.getRepoFile(this.localRoot, file);
                if (repoFile != null) {
                    RepoFile repoFile2 = repoFile;
                    return repoFile2;
                }
                parentRepoFile = this.repoFileDao.getRepoFile(this.localRoot, parentFile);
                if (parentRepoFile == null && parentFile.exists()) {
                    throw new IllegalStateException("RepoFile not found for existing file/dir: " + parentFile.getAbsolutePath());
                }
            }
            monitor.worked(1);
            RepoFile repoFile = this.sync(parentRepoFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 99), recursiveChildren);
            return repoFile;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepoFile sync(RepoFile parentRepoFile, File file, ProgressMonitor monitor, boolean recursiveChildren) {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(monitor, "monitor");
        monitor.beginTask("Local sync...", 100);
        try {
            RepoFile repoFile = this.repoFileDao.getRepoFile(this.localRoot, file);
            if (parentRepoFile != null) {
                boolean ignored;
                boolean bl = ignored = this.isIgnoreRulesEnabled() ? IgnoreRuleManagerImpl.getInstanceForDirectory((File)file.getParentFile()).isIgnored(file) : false;
                if (ignored) {
                    if (repoFile != null) {
                        this.deleteRepoFile(repoFile, false);
                        repoFile = null;
                    }
                    RepoFile repoFile2 = null;
                    return repoFile2;
                }
            }
            if (repoFile != null && !this.isRepoFileTypeCorrect(repoFile, file)) {
                this.deleteRepoFile(repoFile, false);
                repoFile = null;
            }
            boolean fileIsSymlink = file.isSymbolicLink();
            if (repoFile == null) {
                if (!fileIsSymlink && !file.exists()) {
                    RepoFile repoFile3 = null;
                    return repoFile3;
                }
                repoFile = this.createRepoFile(parentRepoFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (repoFile == null) {
                    RepoFile repoFile4 = null;
                    return repoFile4;
                }
            } else if (this.isModified(repoFile, file)) {
                this.updateRepoFile(repoFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 50));
            } else {
                monitor.worked(50);
            }
            HashSet<String> childNames = new HashSet<String>();
            if (!fileIsSymlink) {
                SubProgressMonitor childSubProgressMonitor = new SubProgressMonitor(monitor, 50);
                File[] children = file.listFiles((FilenameFilter)new FilenameFilterSkipMetaDir());
                if (children != null && children.length > 0) {
                    childSubProgressMonitor.beginTask("Local sync...", children.length);
                    for (File child : children) {
                        childNames.add(child.getName());
                        if (!recursiveChildren) continue;
                        this.sync(repoFile, child, (ProgressMonitor)new SubProgressMonitor((ProgressMonitor)childSubProgressMonitor, 1), recursiveChildren);
                    }
                }
                childSubProgressMonitor.done();
            }
            Collection<RepoFile> childRepoFiles = this.repoFileDao.getChildRepoFiles(repoFile);
            for (RepoFile childRepoFile : childRepoFiles) {
                if (childNames.contains(childRepoFile.getName())) continue;
                this.deleteRepoFile(childRepoFile);
            }
            this.transaction.flush();
            RepoFile repoFile5 = repoFile;
            return repoFile5;
        }
        finally {
            monitor.done();
        }
    }

    public boolean isRepoFileTypeCorrect(RepoFile repoFile, File file) {
        Objects.requireNonNull(repoFile, "repoFile");
        Objects.requireNonNull(file, "file");
        if (file.isSymbolicLink()) {
            return repoFile instanceof Symlink;
        }
        if (file.isFile()) {
            return repoFile instanceof NormalFile;
        }
        if (file.isDirectory()) {
            return repoFile instanceof Directory;
        }
        return false;
    }

    public boolean isModified(RepoFile repoFile, File file) {
        long fileLastModified = file.getLastModifiedNoFollow();
        if (repoFile.getLastModified().getTime() != fileLastModified) {
            if (logger.isDebugEnabled()) {
                logger.debug("isModified: repoFile.lastModified != file.lastModified: repoFile.lastModified={} file.lastModified={} file={}", new Object[]{repoFile.getLastModified(), new Date(fileLastModified), file});
            }
            return true;
        }
        if (file.isSymbolicLink()) {
            String fileSymlinkTarget;
            if (!(repoFile instanceof Symlink)) {
                throw new IllegalArgumentException("repoFile is not an instance of Symlink! file=" + file);
            }
            Symlink symlink = (Symlink)repoFile;
            try {
                fileSymlinkTarget = file.readSymbolicLinkToPathString();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return !fileSymlinkTarget.equals(symlink.getTarget());
        }
        if (file.isFile()) {
            if (!(repoFile instanceof NormalFile)) {
                throw new IllegalArgumentException("repoFile is not an instance of NormalFile! file=" + file);
            }
            NormalFile normalFile = (NormalFile)repoFile;
            if (normalFile.getLength() != file.length()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("isModified: normalFile.length != file.length: repoFile.length={} file.length={} file={}", new Object[]{normalFile.getLength(), file.length(), file});
                }
                return true;
            }
            if (normalFile.getFileChunks().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepoFile createRepoFile(RepoFile parentRepoFile, File file, ProgressMonitor monitor) {
        if (parentRepoFile == null) {
            throw new IllegalStateException("Creating the root this way is not possible! Why is it not existing, yet?!???");
        }
        monitor.beginTask("Local sync...", 100);
        try {
            RepoFile repoFile = this._createRepoFile(parentRepoFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 98));
            if (repoFile instanceof NormalFile) {
                this.createCopyModificationsIfPossible((NormalFile)repoFile);
            }
            monitor.worked(1);
            RepoFile repoFile2 = this.repoFileDao.makePersistent(repoFile);
            return repoFile2;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepoFile _createRepoFile(RepoFile parentRepoFile, File file, ProgressMonitor monitor) {
        monitor.beginTask("Local sync...", 100);
        try {
            RepoFile repoFile;
            if (file.isSymbolicLink()) {
                repoFile = (RepoFile)ObjectFactoryUtil.createObject(Symlink.class);
                Symlink symlink = (Symlink)repoFile;
                try {
                    symlink.setTarget(file.readSymbolicLinkToPathString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (file.isDirectory()) {
                repoFile = (RepoFile)ObjectFactoryUtil.createObject(Directory.class);
            } else if (file.isFile()) {
                repoFile = (RepoFile)ObjectFactoryUtil.createObject(NormalFile.class);
                NormalFile normalFile = (NormalFile)repoFile;
                this.sha(normalFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 99));
            } else {
                if (file.exists()) {
                    logger.warn("createRepoFile: File exists, but is neither a directory nor a normal file! Skipping: {}", (Object)file);
                } else {
                    logger.warn("createRepoFile: File does not exist! Skipping: {}", (Object)file);
                }
                RepoFile repoFile2 = null;
                return repoFile2;
            }
            repoFile.setParent(parentRepoFile);
            repoFile.setName(file.getName());
            repoFile.setLastModified(new Date(file.getLastModifiedNoFollow()));
            RepoFile repoFile3 = repoFile;
            return repoFile3;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRepoFile(RepoFile repoFile, File file, ProgressMonitor monitor) {
        logger.debug("updateRepoFile: id={} file={}", (Object)repoFile.getId(), (Object)file);
        monitor.beginTask("Local sync...", 100);
        try {
            if (file.isSymbolicLink()) {
                if (!(repoFile instanceof Symlink)) {
                    throw new IllegalArgumentException("repoFile is not an instance of Symlink! file=" + file);
                }
                Symlink symlink = (Symlink)repoFile;
                try {
                    symlink.setTarget(file.readSymbolicLinkToPathString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (file.isFile()) {
                if (!(repoFile instanceof NormalFile)) {
                    throw new IllegalArgumentException("repoFile is not an instance of NormalFile!");
                }
                NormalFile normalFile = (NormalFile)repoFile;
                this.sha(normalFile, file, (ProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
            repoFile.setLastSyncFromRepositoryId(null);
            repoFile.setLastModified(new Date(file.getLastModifiedNoFollow()));
        }
        finally {
            monitor.done();
        }
    }

    public void deleteRepoFile(RepoFile repoFile) {
        this.deleteRepoFile(repoFile, true);
    }

    public void deleteRepoFile(RepoFile repoFile, boolean createDeleteModifications) {
        RepoFile parentRepoFile = Objects.requireNonNull(repoFile, "repoFile").getParent();
        if (parentRepoFile == null) {
            throw new IllegalStateException("Deleting the root is not possible!");
        }
        PersistenceManager pm = ((LocalRepoTransactionImpl)this.transaction).getPersistenceManager();
        pm.flush();
        if (createDeleteModifications) {
            this.createDeleteModifications(repoFile);
        }
        this.deleteRepoFileWithAllChildrenRecursively(repoFile);
        pm.flush();
    }

    private int getMaxCopyModificationCount(NormalFile newNormalFile) {
        long fileLength = newNormalFile.getLength();
        if (fileLength < 10240L) {
            return 0;
        }
        if (fileLength < 102400L) {
            return 1;
        }
        if (fileLength < 0x100000L) {
            return 2;
        }
        if (fileLength < 0xA00000L) {
            return 3;
        }
        if (fileLength < 0x6400000L) {
            return 5;
        }
        if (fileLength < 0x40000000L) {
            return 7;
        }
        if (fileLength < Integer.MIN_VALUE) {
            return 9;
        }
        return 11;
    }

    protected void createCopyModificationsIfPossible(NormalFile newNormalFile) {
        int maxCopyModificationCount = this.getMaxCopyModificationCount(newNormalFile);
        if (maxCopyModificationCount < 1) {
            return;
        }
        HashSet<String> fromPaths = new HashSet<String>();
        Set<String> paths = this.sha1AndLength2Paths.get(this.getSha1AndLength(newNormalFile.getSha1(), newNormalFile.getLength()));
        if (paths != null) {
            ArrayList<String> pathList = new ArrayList<String>(paths);
            Collections.shuffle(pathList);
            for (String path : pathList) {
                this.createCopyModifications(path, newNormalFile, fromPaths);
                if (fromPaths.size() < maxCopyModificationCount) continue;
                return;
            }
        }
        ArrayList<NormalFile> normalFiles = new ArrayList<NormalFile>(this.normalFileDao.getNormalFilesForSha1(newNormalFile.getSha1(), newNormalFile.getLength()));
        Collections.shuffle(normalFiles);
        for (NormalFile normalFile : normalFiles) {
            if (newNormalFile.equals(normalFile)) continue;
            this.createCopyModifications(normalFile, newNormalFile, fromPaths);
            if (fromPaths.size() < maxCopyModificationCount) continue;
            return;
        }
        ArrayList<DeleteModification> deleteModifications = new ArrayList<DeleteModification>(this.deleteModificationDao.getDeleteModificationsForSha1(newNormalFile.getSha1(), newNormalFile.getLength()));
        Collections.shuffle(deleteModifications);
        for (DeleteModification deleteModification : deleteModifications) {
            this.createCopyModifications(deleteModification, newNormalFile, fromPaths);
            if (fromPaths.size() < maxCopyModificationCount) continue;
            return;
        }
    }

    private void createCopyModifications(DeleteModification deleteModification, NormalFile toNormalFile, Set<String> fromPaths) {
        Objects.requireNonNull(deleteModification, "deleteModification");
        Objects.requireNonNull(toNormalFile, "toNormalFile");
        Objects.requireNonNull(fromPaths, "fromPaths");
        if (deleteModification.getLength() != toNormalFile.getLength()) {
            throw new IllegalArgumentException("fromNormalFile.length != toNormalFile.length");
        }
        if (!deleteModification.getSha1().equals(toNormalFile.getSha1())) {
            throw new IllegalArgumentException("fromNormalFile.sha1 != toNormalFile.sha1");
        }
        this.createCopyModifications(deleteModification.getPath(), toNormalFile, fromPaths);
    }

    private void createCopyModifications(String fromPath, NormalFile toNormalFile, Set<String> fromPaths) {
        Objects.requireNonNull(fromPath, "fromPath");
        Objects.requireNonNull(toNormalFile, "toNormalFile");
        Objects.requireNonNull(fromPaths, "fromPaths");
        if (!fromPaths.add(fromPath)) {
            return;
        }
        for (RemoteRepository remoteRepository : this.getRemoteRepositories()) {
            CopyModification modification = new CopyModification();
            modification.setRemoteRepository(remoteRepository);
            modification.setFromPath(fromPath);
            modification.setToPath(toNormalFile.getPath());
            modification.setLength(toNormalFile.getLength());
            modification.setSha1(toNormalFile.getSha1());
            this.modificationDao.makePersistent(modification);
        }
    }

    private void createCopyModifications(NormalFile fromNormalFile, NormalFile toNormalFile, Set<String> fromPaths) {
        Objects.requireNonNull(fromNormalFile, "fromNormalFile");
        Objects.requireNonNull(toNormalFile, "toNormalFile");
        Objects.requireNonNull(fromPaths, "fromPaths");
        if (fromNormalFile.getLength() != toNormalFile.getLength()) {
            throw new IllegalArgumentException("fromNormalFile.length != toNormalFile.length");
        }
        if (!fromNormalFile.getSha1().equals(toNormalFile.getSha1())) {
            throw new IllegalArgumentException("fromNormalFile.sha1 != toNormalFile.sha1");
        }
        this.createCopyModifications(fromNormalFile.getPath(), toNormalFile, fromPaths);
    }

    protected void createDeleteModifications(RepoFile repoFile) {
        Objects.requireNonNull(repoFile, "repoFile");
        for (RemoteRepository remoteRepository : this.getRemoteRepositories()) {
            this.createDeleteModification(repoFile, remoteRepository);
        }
    }

    protected DeleteModification createDeleteModification(RepoFile repoFile, RemoteRepository remoteRepository) {
        Objects.requireNonNull(repoFile, "repoFile");
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        DeleteModification modification = (DeleteModification)ObjectFactoryUtil.createObject(DeleteModification.class);
        this.populateDeleteModification(modification, repoFile, remoteRepository);
        return this.modificationDao.makePersistent(modification);
    }

    protected void populateDeleteModification(DeleteModification modification, RepoFile repoFile, RemoteRepository remoteRepository) {
        Objects.requireNonNull(modification, "modification");
        Objects.requireNonNull(repoFile, "repoFile");
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        NormalFile normalFile = repoFile instanceof NormalFile ? (NormalFile)repoFile : null;
        modification.setRemoteRepository(remoteRepository);
        modification.setPath(repoFile.getPath());
        modification.setLength(normalFile == null ? -1L : normalFile.getLength());
        modification.setSha1(normalFile == null ? null : normalFile.getSha1());
    }

    private Collection<RemoteRepository> getRemoteRepositories() {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = Collections.unmodifiableCollection(this.remoteRepositoryDao.getObjects());
        }
        return this.remoteRepositories;
    }

    protected void deleteRepoFileWithAllChildrenRecursively(RepoFile repoFile) {
        Objects.requireNonNull(repoFile, "repoFile");
        for (RepoFile childRepoFile : this.repoFileDao.getChildRepoFiles(repoFile)) {
            this.deleteRepoFileWithAllChildrenRecursively(childRepoFile);
        }
        this.putIntoSha1AndLength2PathsIfNormalFile(repoFile);
        this.repoFileDao.deletePersistent(repoFile);
    }

    protected void putIntoSha1AndLength2PathsIfNormalFile(RepoFile repoFile) {
        if (repoFile instanceof NormalFile) {
            NormalFile normalFile = (NormalFile)repoFile;
            String sha1AndLength = this.getSha1AndLength(normalFile.getSha1(), normalFile.getLength());
            Set<String> paths = this.sha1AndLength2Paths.get(sha1AndLength);
            if (paths == null) {
                paths = new HashSet<String>(1);
                this.sha1AndLength2Paths.put(sha1AndLength, paths);
            }
            paths.add(normalFile.getPath());
        }
    }

    private String getSha1AndLength(String sha1, long length) {
        return sha1 + ':' + length;
    }

    protected void sha(NormalFile normalFile, File file, ProgressMonitor monitor) {
        monitor.beginTask("Local sync...", (int)Math.min(file.length(), Integer.MAX_VALUE));
        try {
            normalFile.getFileChunks().clear();
            this.transaction.flush();
            MessageDigest mdAll = MessageDigest.getInstance("SHA");
            MessageDigest mdChunk = MessageDigest.getInstance("SHA");
            int bufLength = 32768;
            long offset = 0L;
            try (InputStream in = StreamUtil.castStream((IInputStream)file.createInputStream());){
                FileChunk fileChunk = null;
                byte[] buf = new byte[32768];
                while (true) {
                    int bytesRead;
                    if (fileChunk == null) {
                        fileChunk = (FileChunk)ObjectFactoryUtil.createObject(FileChunk.class);
                        fileChunk.setNormalFile(normalFile);
                        fileChunk.setOffset(offset);
                        fileChunk.setLength(0);
                        mdChunk.reset();
                    }
                    if ((bytesRead = in.read(buf, 0, buf.length)) > 0) {
                        mdAll.update(buf, 0, bytesRead);
                        mdChunk.update(buf, 0, bytesRead);
                        offset += (long)bytesRead;
                        fileChunk.setLength(fileChunk.getLength() + bytesRead);
                    }
                    if (bytesRead < 0 || fileChunk.getLength() >= 0x100000) {
                        fileChunk.setSha1(HashUtil.encodeHexStr((byte[])mdChunk.digest()));
                        this.onFinalizeFileChunk(fileChunk);
                        fileChunk.makeReadOnly();
                        normalFile.getFileChunks().add(fileChunk);
                        fileChunk = null;
                        if (bytesRead < 0) {
                            break;
                        }
                    }
                    if (bytesRead <= 0) continue;
                    monitor.worked(bytesRead);
                }
            }
            normalFile.setSha1(HashUtil.encodeHexStr((byte[])mdAll.digest()));
            normalFile.setLength(offset);
            long fileLength = file.length();
            if (fileLength != offset) {
                logger.warn("sha: file.length() != bytesReadTotal :: File seems to be written concurrently! file='{}' file.length={} bytesReadTotal={}", new Object[]{file, fileLength, offset});
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            monitor.done();
        }
    }

    protected void onFinalizeFileChunk(FileChunk fileChunk) {
    }

    public boolean isIgnoreRulesEnabled() {
        return this.ignoreRulesEnabled;
    }

    public void setIgnoreRulesEnabled(boolean ignoreRulesEnabled) {
        this.ignoreRulesEnabled = ignoreRulesEnabled;
    }

    public LocalRepoSync ignoreRulesEnabled(boolean ignoreRulesEnabled) {
        this.setIgnoreRulesEnabled(ignoreRulesEnabled);
        return this;
    }
}

