/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.ls.rest.client.LocalServerRestClient;
import co.codewizards.cloudstore.ls.server.LocalServer;
import java.io.Console;

public abstract class SubCommand {
    private String subCommandName;
    private LocalServer localServer;

    public String getSubCommandName() {
        if (this.subCommandName == null) {
            String suffix = "SubCommand";
            String simpleName = this.getClass().getSimpleName();
            if (!simpleName.endsWith("SubCommand")) {
                throw new IllegalStateException(String.format("Class name '%s' does not end with suffix '%s'! Rename the class or override the 'getSubCommand()' method!", simpleName, "SubCommand"));
            }
            StringBuilder sb = new StringBuilder();
            sb.append(simpleName.substring(0, simpleName.length() - "SubCommand".length()));
            if (sb.length() == 0) {
                throw new IllegalStateException(String.format("Class name '%s' equals suffix '%s'! There should be sth. before the suffix! Rename the class or override the 'getSubCommand()' method!", simpleName, "SubCommand"));
            }
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            this.subCommandName = sb.toString();
        }
        return this.subCommandName;
    }

    public abstract String getSubCommandDescription();

    public void prepare() throws Exception {
        this.localServer = new LocalServer();
        if (!this.localServer.start()) {
            this.localServer = null;
        }
    }

    public abstract void run() throws Exception;

    public void cleanUp() throws Exception {
        if (this.localServer != null) {
            this.localServer.stop();
            this.localServer = null;
        }
    }

    protected String promptPassword(String fmt, Object ... args) {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("There is no system console! Cannot prompt \"" + String.format(fmt, args) + "\"!!!");
        }
        char[] pw = console.readPassword(fmt, args);
        if (pw == null) {
            return null;
        }
        return new String(pw);
    }

    protected String prompt(String fmt, Object ... args) {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("There is no system console! Cannot prompt \"" + String.format(fmt, args) + "\"!!!");
        }
        String result = console.readLine(fmt, args);
        return result;
    }

    public boolean isVisibleInHelp() {
        return true;
    }

    public LocalServerRestClient getLocalServerRestClient() {
        return LocalServerRestClient.getInstance();
    }
}

