/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommand;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import java.util.UUID;
import org.kohsuke.args4j.Argument;

public class DropRepoAliasSubCommand
extends SubCommand {
    @Argument(metaVar="<alias>", index=0, required=true, usage="The alias to be dropped.")
    private String alias;

    @Override
    public String getSubCommandDescription() {
        return "Drop an alias.";
    }

    @Override
    public void run() throws Exception {
        LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
        UUID oldRepositoryId = localRepoRegistry.getRepositoryId(this.alias);
        File oldLocalRoot = null;
        if (!(oldRepositoryId == null || (oldLocalRoot = localRepoRegistry.getLocalRoot(oldRepositoryId)) != null && oldLocalRoot.exists())) {
            oldRepositoryId = null;
            oldLocalRoot = null;
        }
        if (oldRepositoryId != null) {
            localRepoRegistry.removeRepositoryAlias(this.alias);
            System.out.println(String.format("Dropped alias '%s' for repository %s (local-root '%s').", this.alias, oldRepositoryId, oldLocalRoot));
        } else {
            System.out.println(String.format("WARNING: The alias '%s' does not exist.", this.alias));
        }
    }
}

