/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.transport;

import co.codewizards.cloudstore.core.oio.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ParentFileLastModifiedManager {
    private final Map<File, ParentFileEntry> parentFile2ParentFileEntry = new HashMap<File, ParentFileEntry>();

    private ParentFileLastModifiedManager() {
    }

    public static ParentFileLastModifiedManager getInstance() {
        return ParentFileLastModifiedManagerHolder.instance;
    }

    public synchronized void backupParentFileLastModified(File parentFile) {
        Objects.requireNonNull(parentFile, "parentFile");
        ParentFileEntry parentFileEntry = this.parentFile2ParentFileEntry.get(parentFile);
        if (parentFileEntry == null) {
            parentFileEntry = new ParentFileEntry(parentFile);
            this.parentFile2ParentFileEntry.put(parentFile, parentFileEntry);
        }
        ++parentFileEntry.refCount;
    }

    public synchronized void restoreParentFileLastModified(File parentFile) {
        Objects.requireNonNull(parentFile, "parentFile");
        ParentFileEntry parentFileEntry = this.parentFile2ParentFileEntry.get(parentFile);
        if (parentFileEntry == null) {
            throw new IllegalStateException("parentFileEntry == null :: less invocations of restore... than of backup...!!! :: parentFile=" + parentFile);
        }
        if (--parentFileEntry.refCount == 0) {
            if (parentFileEntry.lastModified != Long.MIN_VALUE) {
                parentFileEntry.parentFile.setLastModified(parentFileEntry.lastModified);
            }
            this.parentFile2ParentFileEntry.remove(parentFile);
        }
    }

    private static final class ParentFileLastModifiedManagerHolder {
        public static final ParentFileLastModifiedManager instance = new ParentFileLastModifiedManager();

        private ParentFileLastModifiedManagerHolder() {
        }
    }

    private static class ParentFileEntry {
        public final File parentFile;
        public final long lastModified;
        public int refCount = 0;

        public ParentFileEntry(File parentFile) {
            this.parentFile = Objects.requireNonNull(parentFile, "parentFile");
            this.lastModified = parentFile.exists() ? parentFile.lastModified() : Long.MIN_VALUE;
        }
    }
}

