/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.updater;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import co.codewizards.cloudstore.core.appid.AppId;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.updater.CloudStoreUpdaterCore;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.updater.PGPVerifier;
import co.codewizards.cloudstore.updater.TarGzEntryNameConverter;
import co.codewizards.cloudstore.updater.TarGzFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreUpdater
extends CloudStoreUpdaterCore {
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreUpdater.class);
    private static final AppId appId = AppIdRegistry.getInstance().getAppIdOrFail();
    private static Class<? extends CloudStoreUpdater> cloudStoreUpdaterClass = CloudStoreUpdater.class;
    private final String[] args;
    private boolean throwException = true;
    @Option(name="-installationDir", required=true, usage="Base-directory of the installation containing the 'bin' directory as well as the 'installation.properties' file - e.g. '/opt/cloudstore'. The installation in this directory will be updated.")
    private String installationDir;
    private co.codewizards.cloudstore.core.oio.File installationDirFile;
    private Properties remoteUpdateProperties;
    private co.codewizards.cloudstore.core.oio.File tempDownloadDir;
    private co.codewizards.cloudstore.core.oio.File localServerRunningFile;
    private LockFile localServerRunningLockFile;
    private co.codewizards.cloudstore.core.oio.File localServerStopFile;
    private static final String RENAMED_FILE_SUFFIX = ".csupdbak";

    public static void main(String[] args) throws Exception {
        CloudStoreUpdater.initLogging();
        try {
            int programExitStatus = CloudStoreUpdater.createCloudStoreUpdater(args).throwException(false).execute();
            System.exit(programExitStatus);
        }
        catch (Throwable x) {
            logger.error(x.toString(), x);
            System.exit(999);
        }
    }

    protected static Constructor<? extends CloudStoreUpdater> getCloudStoreUpdaterConstructor() throws NoSuchMethodException, SecurityException {
        Class<? extends CloudStoreUpdater> clazz = CloudStoreUpdater.getCloudStoreUpdaterClass();
        Constructor<? extends CloudStoreUpdater> constructor = clazz.getConstructor(String[].class);
        return constructor;
    }

    protected static CloudStoreUpdater createCloudStoreUpdater(String[] args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<? extends CloudStoreUpdater> constructor = CloudStoreUpdater.getCloudStoreUpdaterConstructor();
        CloudStoreUpdater cloudStoreUpdater = constructor.newInstance(new Object[]{args});
        return cloudStoreUpdater;
    }

    protected static Class<? extends CloudStoreUpdater> getCloudStoreUpdaterClass() {
        return cloudStoreUpdaterClass;
    }

    protected static void setCloudStoreUpdaterClass(Class<? extends CloudStoreUpdater> cloudStoreUpdaterClass) {
        AssertUtil.assertNotNull(cloudStoreUpdaterClass, (String)"cloudStoreUpdaterClass");
        CloudStoreUpdater.cloudStoreUpdaterClass = cloudStoreUpdaterClass;
    }

    public CloudStoreUpdater(String[] args) {
        this.args = args;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public CloudStoreUpdater throwException(boolean throwException) {
        this.setThrowException(throwException);
        return this;
    }

    public int execute() throws Exception {
        int programExitStatus;
        block4: {
            programExitStatus = 1;
            CmdLineParser parser = new CmdLineParser((Object)this);
            try {
                parser.parseArgument(this.args);
                this.run();
                programExitStatus = 0;
            }
            catch (CmdLineException e) {
                programExitStatus = 2;
                System.err.println("Error: " + e.getMessage());
                System.err.println();
                if (this.throwException) {
                    throw e;
                }
            }
            catch (Exception x) {
                programExitStatus = 3;
                logger.error(x.toString(), (Throwable)x);
                if (!this.throwException) break block4;
                throw x;
            }
        }
        return programExitStatus;
    }

    private static void initLogging() throws IOException, JoranException {
        ConfigDir.getInstance().getLogDir();
        String logbackXmlName = "logback.updater.xml";
        co.codewizards.cloudstore.core.oio.File logbackXmlFile = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)ConfigDir.getInstance().getFile(), (String[])new String[]{"logback.updater.xml"});
        if (!logbackXmlFile.exists()) {
            AppIdRegistry.getInstance().copyResourceResolvingAppId(CloudStoreUpdater.class, "logback.updater.xml", logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile.getIoFile());
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        System.out.println(String.format("%s updater started. Downloading meta-data.", appId.getName()));
        boolean restoreRenamedFiles = false;
        try {
            this.stopLocalServer();
            long localServerStoppedTimestamp = System.currentTimeMillis();
            co.codewizards.cloudstore.core.oio.File downloadFile = this.downloadURLViaRemoteUpdateProperties("artifact[${artifactId}].downloadURL");
            co.codewizards.cloudstore.core.oio.File signatureFile = this.downloadURLViaRemoteUpdateProperties("artifact[${artifactId}].signatureURL");
            System.out.println("Verifying PGP signature.");
            new PGPVerifier().verify(downloadFile, signatureFile);
            long durationAfterLocalServerStop = System.currentTimeMillis() - localServerStoppedTimestamp;
            long additionalWaitTime = 10000L - durationAfterLocalServerStop;
            if (additionalWaitTime > 0L) {
                Thread.sleep(additionalWaitTime);
            }
            this.checkAvailableDiskSpace(this.getInstallationDir(), downloadFile.length() * 5L);
            co.codewizards.cloudstore.core.oio.File backupDir = this.getBackupDir();
            backupDir.mkdirs();
            co.codewizards.cloudstore.core.oio.File backupTarGzFile = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)backupDir, (String[])new String[]{this.resolve(String.format("${artifactId}-${localVersion}.backup-%s.tar.gz", Long.toString(System.currentTimeMillis(), 36)))});
            System.out.println("Creating backup: " + backupTarGzFile);
            new TarGzFile(backupTarGzFile).fileFilter(this.fileFilterIgnoringBackupAndUpdaterDir).compress(this.getInstallationDir());
            System.out.println("Renaming files in installation directory: " + this.getInstallationDir());
            restoreRenamedFiles = true;
            this.renameFiles(this.getInstallationDir(), this.fileFilterIgnoringBackupAndUpdaterDir);
            System.out.println("Overwriting installation directory: " + this.getInstallationDir());
            HashSet<co.codewizards.cloudstore.core.oio.File> keepFiles = new HashSet<co.codewizards.cloudstore.core.oio.File>();
            keepFiles.add(this.getInstallationDir());
            this.populateFilesRecursively(this.getBackupDir(), keepFiles);
            this.populateFilesRecursively(this.getUpdaterDir(), keepFiles);
            new TarGzFile(downloadFile).tarGzEntryNameConverter(new ExtractTarGzEntryNameConverter()).fileFilter(new FileFilterTrackingExtractedFiles(keepFiles)).extract(this.getInstallationDir());
            restoreRenamedFiles = false;
            System.out.println("Deleting old files from installation directory: " + this.getInstallationDir());
            this.deleteAllExcept(this.getInstallationDir(), keepFiles);
        }
        finally {
            if (restoreRenamedFiles) {
                this.restoreRenamedFiles(this.getInstallationDir());
            }
            if (this.tempDownloadDir != null) {
                System.out.println("Deleting temporary download-directory.");
                IOUtil.deleteDirectoryRecursively((co.codewizards.cloudstore.core.oio.File)this.tempDownloadDir);
            }
            if (this.localServerRunningLockFile != null) {
                this.localServerRunningLockFile.release();
                this.localServerRunningLockFile = null;
            }
        }
        System.out.println("Update successfully done. Exiting.");
    }

    private void stopLocalServer() {
        try {
            boolean localServerRunning;
            boolean bl = localServerRunning = !this.tryAcquireLocalServerRunningLockFile();
            if (localServerRunning) {
                System.out.println("LocalServer is running. Stopping it...");
                co.codewizards.cloudstore.core.oio.File localServerStopFile = this.getLocalServerStopFile();
                if (localServerStopFile.exists()) {
                    localServerStopFile.delete();
                    if (localServerStopFile.exists()) {
                        logger.warn("Failed to delete file: {}", (Object)localServerStopFile);
                    } else {
                        System.out.println("File successfully deleted: " + localServerStopFile);
                    }
                } else {
                    System.out.println("WARNING: File does not exist (could thus not delete it): " + localServerStopFile);
                    logger.warn("File does not exist: {}", (Object)localServerStopFile);
                }
                System.out.println("Waiting for LocalServer to stop...");
                long waitStartTimestamp = System.currentTimeMillis();
                do {
                    if (System.currentTimeMillis() - waitStartTimestamp <= 120000L) continue;
                    throw new TimeoutException("LocalServer did not stop within timeout!");
                } while (localServerRunning = !this.tryAcquireLocalServerRunningLockFile());
                System.out.println("LocalServer stopped.");
            }
        }
        catch (Exception x) {
            logger.error("stopLocalServer: " + x, (Throwable)x);
            x.printStackTrace();
        }
    }

    private co.codewizards.cloudstore.core.oio.File getLocalServerRunningFile() {
        if (this.localServerRunningFile == null) {
            this.localServerRunningFile = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServerRunning.lock"});
            try {
                this.localServerRunningFile = this.localServerRunningFile.getCanonicalFile();
            }
            catch (IOException x) {
                logger.warn("getLocalServerRunningFile: " + x, (Throwable)x);
            }
        }
        return this.localServerRunningFile;
    }

    private co.codewizards.cloudstore.core.oio.File getLocalServerStopFile() {
        if (this.localServerStopFile == null) {
            this.localServerStopFile = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localServerRunning.deleteToStop"});
        }
        return this.localServerStopFile;
    }

    private boolean tryAcquireLocalServerRunningLockFile() {
        if (this.localServerRunningLockFile != null) {
            logger.warn("tryAcquireLocalServerRunningLockFile: Already acquired before!!! Skipping!");
            return true;
        }
        try {
            this.localServerRunningLockFile = LockFileFactory.getInstance().acquire(this.getLocalServerRunningFile(), 1000L);
            return true;
        }
        catch (TimeoutException x) {
            return false;
        }
    }

    private void checkAvailableDiskSpace(co.codewizards.cloudstore.core.oio.File dir, long expectedRequiredSpace) throws IOException {
        long usableSpace = dir.getUsableSpace();
        logger.debug("checkAvailableDiskSpace: dir='{}' dir.usableSpace='{} MiB' expectedRequiredSpace='{} MiB'", new Object[]{dir, usableSpace / 1024L / 1024L, expectedRequiredSpace / 1024L / 1024L});
        if (usableSpace < expectedRequiredSpace) {
            String msg = String.format("Insufficient disk space! The file system of the directory '%s' has %s MiB (%s B) available, but %s MiB (%s B) are required!", dir, usableSpace / 1024L / 1024L, usableSpace, expectedRequiredSpace / 1024L / 1024L, expectedRequiredSpace);
            logger.error("checkAvailableDiskSpace: " + msg);
            throw new IOException(msg);
        }
    }

    private void renameFiles(co.codewizards.cloudstore.core.oio.File dir, FileFilter fileFilter) throws IOException {
        co.codewizards.cloudstore.core.oio.File[] children = dir.listFiles(fileFilter);
        if (children != null) {
            for (co.codewizards.cloudstore.core.oio.File child : children) {
                if (child.isDirectory()) {
                    this.renameFiles(child, fileFilter);
                    continue;
                }
                co.codewizards.cloudstore.core.oio.File newChild = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)dir, (String[])new String[]{child.getName() + RENAMED_FILE_SUFFIX});
                logger.debug("renameFiles: file='{}', newName='{}'", (Object)child, (Object)newChild.getName());
                if (child.renameTo(newChild)) continue;
                String msg = String.format("Failed to rename the file '%s' to '%s' (in the same directory)!", child, newChild.getName());
                logger.error("renameFiles: {}", (Object)msg);
                throw new IOException(msg);
            }
        }
    }

    private void restoreRenamedFiles(co.codewizards.cloudstore.core.oio.File dir) {
        co.codewizards.cloudstore.core.oio.File[] children = dir.listFiles();
        if (children != null) {
            for (co.codewizards.cloudstore.core.oio.File child : children) {
                if (child.isDirectory()) {
                    this.restoreRenamedFiles(child);
                    continue;
                }
                if (!child.getName().endsWith(RENAMED_FILE_SUFFIX)) continue;
                co.codewizards.cloudstore.core.oio.File newChild = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)dir, (String[])new String[]{child.getName().substring(0, child.getName().length() - RENAMED_FILE_SUFFIX.length())});
                logger.debug("restoreRenamedFiles: file='{}', newName='{}'", (Object)child, (Object)newChild.getName());
                newChild.delete();
                if (child.renameTo(newChild)) continue;
                logger.warn("restoreRenamedFiles: Failed to rename the file '{}' back to its original name '{}' (in the same directory)!", (Object)child, (Object)newChild.getName());
            }
        }
    }

    private void populateFilesRecursively(co.codewizards.cloudstore.core.oio.File fileOrDir, Set<co.codewizards.cloudstore.core.oio.File> files) {
        AssertUtil.assertNotNull((Object)fileOrDir, (String)"fileOrDir");
        AssertUtil.assertNotNull(files, (String)"files");
        files.add(fileOrDir);
        co.codewizards.cloudstore.core.oio.File[] children = fileOrDir.listFiles();
        if (children != null) {
            for (co.codewizards.cloudstore.core.oio.File child : children) {
                this.populateFilesRecursively(child, files);
            }
        }
    }

    private void deleteAllExcept(co.codewizards.cloudstore.core.oio.File fileOrDir, Set<co.codewizards.cloudstore.core.oio.File> keepFiles) {
        AssertUtil.assertNotNull((Object)fileOrDir, (String)"fileOrDir");
        AssertUtil.assertNotNull(keepFiles, (String)"keepFiles");
        if (keepFiles.contains(fileOrDir)) {
            logger.debug("deleteAllExcept: Keeping: {}", (Object)fileOrDir);
            co.codewizards.cloudstore.core.oio.File[] children = fileOrDir.listFiles();
            if (children != null) {
                for (co.codewizards.cloudstore.core.oio.File child : children) {
                    this.deleteAllExcept(child, keepFiles);
                }
            }
        } else {
            logger.debug("deleteAllExcept: Deleting: {}", (Object)fileOrDir);
            IOUtil.deleteDirectoryRecursively((co.codewizards.cloudstore.core.oio.File)fileOrDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private co.codewizards.cloudstore.core.oio.File downloadURLViaRemoteUpdateProperties(String remoteUpdatePropertiesKey) {
        logger.debug("downloadURLViaRemoteUpdateProperties: remoteUpdatePropertiesKey='{}'", (Object)remoteUpdatePropertiesKey);
        String resolvedKey = this.resolve(remoteUpdatePropertiesKey);
        String urlStr = this.getRemoteUpdateProperties().getProperty(resolvedKey);
        if (urlStr == null || urlStr.trim().isEmpty()) {
            throw new IllegalStateException("No value for key in remoteUpdateProperties: " + resolvedKey);
        }
        String resolvedURLStr = this.resolve(urlStr);
        logger.debug("downloadURLViaRemoteUpdateProperties: resolvedURLStr='{}'", (Object)resolvedURLStr);
        co.codewizards.cloudstore.core.oio.File tempDownloadDir = this.getTempDownloadDir();
        try {
            System.out.println("Downloading: " + resolvedURLStr);
            URL url = new URL(resolvedURLStr);
            long contentLength = url.openConnection().getContentLengthLong();
            if (contentLength < 0L) {
                logger.warn("downloadURLViaRemoteUpdateProperties: contentLength unknown! url='{}'", (Object)url);
            } else {
                logger.debug("downloadURLViaRemoteUpdateProperties: contentLength={} url='{}'", (Object)contentLength, (Object)url);
                this.checkAvailableDiskSpace(tempDownloadDir, Math.max(0x100000L, contentLength * 3L / 2L));
            }
            int logLastPercentage = -100;
            int logStepPercentageDiff = 5;
            long downloadedLength = 0L;
            String path = url.getPath();
            int lastSlashIndex = path.lastIndexOf(47);
            if (lastSlashIndex < 0) {
                throw new IllegalStateException("No '/' found in URL?!");
            }
            String fileName = path.substring(lastSlashIndex + 1);
            co.codewizards.cloudstore.core.oio.File downloadFile = OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)tempDownloadDir, (String[])new String[]{fileName});
            boolean successful = false;
            InputStream in = url.openStream();
            try {
                OutputStream out = StreamUtil.castStream((IOutputStream)downloadFile.createOutputStream());
                try {
                    int bytesRead;
                    byte[] buf = new byte[65535];
                    while ((bytesRead = in.read(buf)) >= 0) {
                        int percentage;
                        out.write(buf, 0, bytesRead);
                        if (contentLength <= 0L || 5 > (percentage = (int)((downloadedLength += (long)bytesRead) * 100L / contentLength)) - logLastPercentage) continue;
                        logLastPercentage = percentage;
                        System.out.printf(" ... %d%%", percentage);
                    }
                }
                finally {
                    out.close();
                    System.out.println();
                }
                successful = true;
            }
            finally {
                in.close();
                if (!successful) {
                    downloadFile.delete();
                }
            }
            return downloadFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private co.codewizards.cloudstore.core.oio.File getTempDownloadDir() {
        if (this.tempDownloadDir == null) {
            try {
                this.tempDownloadDir = IOUtil.createUniqueRandomFolder((co.codewizards.cloudstore.core.oio.File)IOUtil.getTempDir(), (String)"cloudstore-update-");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.tempDownloadDir;
    }

    protected co.codewizards.cloudstore.core.oio.File getInstallationDir() {
        if (this.installationDirFile == null) {
            String path = IOUtil.simplifyPath((co.codewizards.cloudstore.core.oio.File)OioFileFactory.createFile((String)((String)AssertUtil.assertNotNull((Object)this.installationDir, (String)"installationDir"))));
            co.codewizards.cloudstore.core.oio.File f = OioFileFactory.createFile((String)path);
            if (!f.exists()) {
                throw new IllegalArgumentException(String.format("installationDir '%s' (specified as '%s') does not exist!", f, this.installationDir));
            }
            if (!f.isDirectory()) {
                throw new IllegalArgumentException(String.format("installationDir '%s' (specified as '%s') is not a directory!", f, this.installationDir));
            }
            this.installationDirFile = f;
        }
        return this.installationDirFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getRemoteUpdateProperties() {
        if (this.remoteUpdateProperties == null) {
            String resolvedRemoteUpdatePropertiesURL = this.resolve(remoteUpdatePropertiesURL);
            Properties properties = new Properties();
            try {
                URL url = new URL(resolvedRemoteUpdatePropertiesURL);
                try (InputStream in = url.openStream();){
                    properties.load(in);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.remoteUpdateProperties = properties;
        }
        return this.remoteUpdateProperties;
    }

    private static class ExtractTarGzEntryNameConverter
    implements TarGzEntryNameConverter {
        private ExtractTarGzEntryNameConverter() {
        }

        @Override
        public String getEntryName(co.codewizards.cloudstore.core.oio.File rootDir, co.codewizards.cloudstore.core.oio.File file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public co.codewizards.cloudstore.core.oio.File getFile(co.codewizards.cloudstore.core.oio.File rootDir, String entryName) {
            int slashIndex;
            String prefix1 = appId.getSimpleId() + "/";
            String prefix2 = appId.getSimpleId() + "-";
            if (entryName.startsWith(prefix1)) {
                entryName = entryName.substring(prefix1.length());
            } else if (entryName.startsWith(prefix2) && (slashIndex = entryName.indexOf(47, prefix2.length())) >= 0) {
                entryName = entryName.substring(slashIndex + 1);
            }
            return entryName.isEmpty() ? rootDir : OioFileFactory.createFile((co.codewizards.cloudstore.core.oio.File)rootDir, (String[])new String[]{entryName});
        }
    }

    private static class FileFilterTrackingExtractedFiles
    implements FileFilter {
        private final Collection<co.codewizards.cloudstore.core.oio.File> files;

        public FileFilterTrackingExtractedFiles(Collection<co.codewizards.cloudstore.core.oio.File> files) {
            this.files = (Collection)AssertUtil.assertNotNull(files, (String)"files");
        }

        @Override
        public boolean accept(File file) {
            this.files.add(OioFileFactory.createFile((File)file));
            this.files.add(OioFileFactory.createFile((File)file.getParentFile()));
            return true;
        }
    }
}

