/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.updater;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.updater.PGPVerifyException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class PGPVerifier {
    private PGPPublicKeyRingCollection publicKeyRingWithTrustedKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(File file, File signatureFile) throws PGPVerifyException {
        AssertUtil.assertNotNull((Object)file, (String)"file");
        AssertUtil.assertNotNull((Object)signatureFile, (String)"signatureFile");
        PGPSignatureList sl = this.readSignatureFile(signatureFile);
        PGPPublicKeyRingCollection publicKeyRing = this.getPublicKeyRingWithTrustedKeys();
        for (int index = 0; index < sl.size(); ++index) {
            try {
                PGPSignature signature = sl.get(index);
                signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKeyRing.getPublicKey(signature.getKeyID()));
                try (InputStream contentIn = StreamUtil.castStream((IInputStream)file.createInputStream());){
                    int len;
                    byte[] buf = new byte[16384];
                    while (0 <= (len = contentIn.read(buf))) {
                        if (len <= 0) continue;
                        signature.update(buf, 0, len);
                    }
                }
                if (!signature.verify()) continue;
                return;
            }
            catch (Exception e) {
                throw new PGPVerifyException(file.getAbsolutePath() + ": " + e, e);
            }
        }
        throw new PGPVerifyException(file.getAbsolutePath());
    }

    private PGPPublicKeyRingCollection getPublicKeyRingWithTrustedKeys() {
        try {
            PGPPublicKeyRingCollection ring = this.publicKeyRingWithTrustedKeys;
            if (ring == null) {
                try (BufferedInputStream publicKeyIn = new BufferedInputStream(PGPVerifier.class.getResourceAsStream("/0x4AB0FBC1.asc"));){
                    ring = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)publicKeyIn), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                this.publicKeyRingWithTrustedKeys = ring;
            }
            return ring;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPSignatureList readSignatureFile(File signatureFile) throws PGPVerifyException {
        PGPSignatureList pGPSignatureList;
        AssertUtil.assertNotNull((Object)signatureFile, (String)"signatureFile");
        if (!signatureFile.isFile() || !signatureFile.canRead()) {
            throw new PGPVerifyException("The signature-file does not exist or is not readable: " + signatureFile.getAbsolutePath());
        }
        BufferedInputStream in = new BufferedInputStream(StreamUtil.castStream((IInputStream)signatureFile.createInputStream()));
        try {
            PGPSignatureList sl;
            PGPObjectFactory objectFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            pGPSignatureList = sl = (PGPSignatureList)objectFactory.nextObject();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PGPVerifyException(signatureFile.getAbsolutePath() + ": " + e, e);
            }
        }
        ((InputStream)in).close();
        return pGPSignatureList;
    }
}

