/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.persistence.Modification;
import java.util.Objects;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="DeleteModification")
@Indices(value={@Index(name="DeleteModification_pathSha1", members={"pathSha1"}), @Index(name="DeleteModification_sha1_length", members={"sha1", "length"})})
@Queries(value={@Query(name="getDeleteModificationsForPathAfter_pathSha1_localRevision_remoteRepository", value="SELECT WHERE this.pathSha1 == :pathSha1 && this.localRevision > :localRevision"), @Query(name="getDeleteModifications_sha1_length", value="SELECT WHERE this.sha1 == :sha1 && this.length == :length")})
public class DeleteModification
extends Modification
implements Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION, defaultFetchGroup="true")
    @Column(jdbcType="CLOB")
    private String path;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String pathSha1;
    private long length;
    private String sha1;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public String getPath() {
        return DeleteModification.dnGetpath(this);
    }

    public void setPath(String path) {
        Objects.requireNonNull(path, "path");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path is empty! path must start with '/' and thus has a minimum length of 1 char!");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path does not start with '/'!");
        }
        DeleteModification.dnSetpath(this, path);
        DeleteModification.dnSetpathSha1(this, HashUtil.sha1((String)path));
    }

    public long getLength() {
        return DeleteModification.dnGetlength(this);
    }

    public void setLength(long length) {
        DeleteModification.dnSetlength(this, length);
    }

    public String getSha1() {
        return DeleteModification.dnGetsha1(this);
    }

    public void setSha1(String sha1) {
        DeleteModification.dnSetsha1(this, sha1);
    }

    static {
        dnFieldNames = DeleteModification.__dnFieldNamesInit();
        dnFieldTypes = DeleteModification.__dnFieldTypesInit();
        dnFieldFlags = DeleteModification.__dnFieldFlagsInit();
        dnInheritedFieldCount = DeleteModification.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = DeleteModification.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)DeleteModification.___dn$loadClass("co.codewizards.cloudstore.local.persistence.DeleteModification"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new DeleteModification());
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        DeleteModification result = new DeleteModification();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        DeleteModification result = new DeleteModification();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.length = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.pathSha1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.sha1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.length);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.pathSha1);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.sha1);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(DeleteModification obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.length = obj.length;
                break;
            }
            case 1: {
                this.path = obj.path;
                break;
            }
            case 2: {
                this.pathSha1 = obj.pathSha1;
                break;
            }
            case 3: {
                this.sha1 = obj.sha1;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof DeleteModification)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.DeleteModification");
        }
        DeleteModification other = (DeleteModification)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"length", "path", "pathSha1", "sha1"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Long.TYPE, DeleteModification.___dn$loadClass("java.lang.String"), DeleteModification.___dn$loadClass("java.lang.String"), DeleteModification.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Modification.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 4 + Modification.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return DeleteModification.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Modification");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        DeleteModification o = (DeleteModification)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static long dnGetlength(DeleteModification objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.length);
        }
        return objPC.length;
    }

    private static void dnSetlength(DeleteModification objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.length, val);
        } else {
            objPC.length = val;
        }
    }

    private static String dnGetpath(DeleteModification objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.path);
        }
        return objPC.path;
    }

    private static void dnSetpath(DeleteModification objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.path, val);
        } else {
            objPC.path = val;
        }
    }

    private static String dnGetpathSha1(DeleteModification objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.pathSha1);
        }
        return objPC.pathSha1;
    }

    private static void dnSetpathSha1(DeleteModification objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.pathSha1, val);
        } else {
            objPC.pathSha1 = val;
        }
    }

    private static String dnGetsha1(DeleteModification objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.sha1);
        }
        return objPC.sha1;
    }

    private static void dnSetsha1(DeleteModification objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.sha1, val);
        } else {
            objPC.sha1 = val;
        }
    }
}

