/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.concurrent;

import co.codewizards.cloudstore.core.concurrent.CallableProvider;
import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.concurrent.ExecutionException;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferrableExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DeferrableExecutor.class);
    public static final String CONFIG_KEY_TIMEOUT = "deferrableExecutor.timeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    public static final String CONFIG_KEY_EXPIRY_PERIOD = "deferrableExecutor.expiryPeriod";
    private static final int DEFAULT_EXPIRY_PERIOD = 3600000;
    private final Map<String, WeakReference<String>> canonicalCallIdentifierMap = new WeakHashMap<String, WeakReference<String>>();
    private final Map<String, Future<?>> callIdentifier2Future = Collections.synchronizedMap(new HashMap());
    private final Map<String, Date> callIdentifier2DoneDate = Collections.synchronizedMap(new WeakHashMap());
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Timer cleanUpExpiredEntriesTimer = new Timer("cleanUpExpiredEntriesTimer", true);
    private TimerTask cleanUpExpiredEntriesTimerTask;
    private int lastExpiryPeriod;

    private DeferrableExecutor() {
    }

    public static DeferrableExecutor getInstance() {
        return RunnableWithProgressExecutorHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V call(String callIdentifier, CallableProvider<V> callableProvider) throws DeferredCompletionException, ExecutionException {
        Objects.requireNonNull(callIdentifier, "callIdentifier");
        Objects.requireNonNull(callableProvider, "callableProvider");
        int timeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_TIMEOUT, 60000);
        this.cleanUpExpiredEntries();
        String string = callIdentifier = this.canonicalizeCallIdentifier(callIdentifier);
        synchronized (string) {
            Object result;
            Future<Object> future = this.callIdentifier2Future.get(callIdentifier);
            if (future == null) {
                Callable<V> callable = callableProvider.getCallable();
                future = this.executorService.submit(new CallableWrapper<V>(callIdentifier, callable));
                this.callIdentifier2Future.put(callIdentifier, future);
            }
            try {
                result = future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new DeferredCompletionException(e);
            }
            catch (TimeoutException e) {
                throw new DeferredCompletionException(e);
            }
            catch (java.util.concurrent.ExecutionException e) {
                this.callIdentifier2Future.remove(callIdentifier);
                throw new ExecutionException(e);
            }
            this.callIdentifier2Future.remove(callIdentifier);
            return (V)result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String canonicalizeCallIdentifier(String callIdentifier) {
        Map<String, WeakReference<String>> map = this.canonicalCallIdentifierMap;
        synchronized (map) {
            String ci;
            WeakReference<String> ref = this.canonicalCallIdentifierMap.get(callIdentifier);
            String string = ci = ref == null ? null : (String)ref.get();
            if (ci == null) {
                ci = callIdentifier;
                this.canonicalCallIdentifierMap.put(ci, new WeakReference<String>(ci));
            }
            return ci;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpExpiredEntries() {
        this.rescheduleExpiredEntriesTimerTaskIfExpiryPeriodChanged();
        LinkedList<String> expiredCallIdentifiers = new LinkedList<String>();
        Date expireDoneBeforeDate = new Date(System.currentTimeMillis() - (long)this.getExpiryPeriod());
        Object object = this.callIdentifier2DoneDate;
        synchronized (object) {
            for (Map.Entry<String, Date> me : this.callIdentifier2DoneDate.entrySet()) {
                if (!me.getValue().before(expireDoneBeforeDate)) continue;
                expiredCallIdentifiers.add(me.getKey());
            }
        }
        object = expiredCallIdentifiers.iterator();
        while (object.hasNext()) {
            String callIdentifier;
            String string = callIdentifier = (String)object.next();
            synchronized (string) {
                this.callIdentifier2Future.remove(callIdentifier);
                this.callIdentifier2DoneDate.remove(callIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleExpiredEntriesTimerTaskIfExpiryPeriodChanged() {
        Timer timer = this.cleanUpExpiredEntriesTimer;
        synchronized (timer) {
            int expiryPeriod = this.getExpiryPeriod();
            if (this.cleanUpExpiredEntriesTimerTask == null || this.lastExpiryPeriod != expiryPeriod) {
                if (this.cleanUpExpiredEntriesTimerTask != null) {
                    this.cleanUpExpiredEntriesTimerTask.cancel();
                }
                this.scheduleExpiredEntriesTimerTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleExpiredEntriesTimerTask() {
        Timer timer = this.cleanUpExpiredEntriesTimer;
        synchronized (timer) {
            int expiryPeriod;
            this.lastExpiryPeriod = expiryPeriod = this.getExpiryPeriod();
            this.cleanUpExpiredEntriesTimerTask = new TimerTask(){

                @Override
                public void run() {
                    DeferrableExecutor.this.cleanUpExpiredEntries();
                }
            };
            this.cleanUpExpiredEntriesTimer.schedule(this.cleanUpExpiredEntriesTimerTask, expiryPeriod / 2, (long)(expiryPeriod / 2));
        }
    }

    private int getExpiryPeriod() {
        return ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_EXPIRY_PERIOD, 3600000);
    }

    private class CallableWrapper<V>
    implements Callable<V> {
        private final String identifier;
        private final Callable<V> delegate;

        public CallableWrapper(String identifier, Callable<V> delegate) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public V call() throws Exception {
            try {
                V v = this.delegate.call();
                return v;
            }
            finally {
                DeferrableExecutor.this.callIdentifier2DoneDate.put(this.identifier, new Date());
            }
        }
    }

    private static final class RunnableWithProgressExecutorHolder {
        private static final DeferrableExecutor instance = new DeferrableExecutor();

        private RunnableWithProgressExecutorHolder() {
        }
    }
}

