/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.bean;

import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;

public class BeanSupport<B, P extends PropertyBase> {
    private final B bean;
    private final PropertyChangeSupport propertyChangeSupport;

    public BeanSupport(B bean) {
        this.bean = Objects.requireNonNull(bean, "bean");
        this.propertyChangeSupport = new PropertyChangeSupport(bean);
    }

    public B getBean() {
        return this.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValue(P property, Object value) {
        Object old;
        Objects.requireNonNull(property, "property");
        Object object = this.getMutex();
        synchronized (object) {
            old = ReflectionUtil.getFieldValue(this.bean, property.name());
            if (this.isEqual(property, old, value)) {
                return;
            }
            ReflectionUtil.setFieldValue(this.bean, property.name(), value);
        }
        this.firePropertyChange(property, old, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getPropertyValue(P property) {
        Object object = this.getMutex();
        synchronized (object) {
            return ReflectionUtil.getFieldValue(this.bean, property.name());
        }
    }

    protected Object getMutex() {
        return this.bean;
    }

    protected boolean isEqual(P property, Object oldValue, Object newValue) {
        return Util.equal(oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(P property, PropertyChangeListener listener) {
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    public void removePropertyChangeListener(P property, PropertyChangeListener listener) {
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    public void firePropertyChange(P property, Object oldValue, Object newValue) {
        Objects.requireNonNull(property, "property");
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }
}

