/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke.filter;

import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.filter.AbstractInvocationFilter;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import java.lang.reflect.Proxy;

public class AllowCloudStoreInvocationFilter
extends AbstractInvocationFilter {
    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Boolean canInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        Class<?> targetClass = extMethodInvocationRequest.getTargetClass();
        if (this.isBlackListed(targetClass)) {
            return false;
        }
        if (this.isWhiteListed(targetClass)) {
            return true;
        }
        if (Proxy.isProxyClass(targetClass)) {
            for (Class iface : ReflectionUtil.getAllInterfaces(targetClass)) {
                if (!this.isWhiteListed(iface)) continue;
                return true;
            }
        }
        return null;
    }

    private boolean isBlackListed(Class<?> classOrInterface) {
        return ReflectionUtil.class.equals(classOrInterface);
    }

    private boolean isWhiteListed(Class<?> classOrInterface) {
        return classOrInterface.getName().startsWith("co.codewizards.cloudstore.");
    }
}

