/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class SignedFileProcessor {
    private static void verifyFile(InputStream in, InputStream keyIn) throws Exception {
        int ch;
        in = PGPUtil.getDecoderStream(in);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = p1.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey key = pgpRing.getPublicKey(ops.getKeyID());
        FileOutputStream out = new FileOutputStream(p2.getFileName());
        ops.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), key);
        while ((ch = dIn.read()) >= 0) {
            ops.update((byte)ch);
            out.write(ch);
        }
        out.close();
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        if (ops.verify(p3.get(0))) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void signFile(String fileName, InputStream keyIn, OutputStream out, char[] pass, boolean armor) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        int ch;
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        PGPSecretKey pgpSec = PGPExampleUtil.readSecretKey(keyIn);
        PGPPrivateKey pgpPrivKey = pgpSec.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(pass));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pgpSec.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        sGen.init(0, pgpPrivKey);
        Iterator<String> it = pgpSec.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, it.next());
            sGen.setHashedSubpackets(spGen.generate());
        }
        PGPCompressedDataGenerator cGen = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bOut = new BCPGOutputStream(cGen.open(out));
        sGen.generateOnePassVersion(false).encode(bOut);
        File file = new File(fileName);
        PGPLiteralDataGenerator lGen = new PGPLiteralDataGenerator();
        OutputStream lOut = lGen.open(bOut, 'b', file);
        FileInputStream fIn = new FileInputStream(file);
        while ((ch = fIn.read()) >= 0) {
            lOut.write(ch);
            sGen.update((byte)ch);
        }
        lGen.close();
        sGen.generate().encode(bOut);
        cGen.close();
        if (armor) {
            out.close();
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-s")) {
            if (args[1].equals("-a")) {
                FileInputStream keyIn = new FileInputStream(args[3]);
                FileOutputStream out = new FileOutputStream(args[2] + ".asc");
                SignedFileProcessor.signFile(args[2], keyIn, out, args[4].toCharArray(), true);
            } else {
                FileInputStream keyIn = new FileInputStream(args[2]);
                FileOutputStream out = new FileOutputStream(args[1] + ".bpg");
                SignedFileProcessor.signFile(args[1], keyIn, out, args[3].toCharArray(), false);
            }
        } else if (args[0].equals("-v")) {
            FileInputStream in = new FileInputStream(args[1]);
            FileInputStream keyIn = new FileInputStream(args[2]);
            SignedFileProcessor.verifyFile(in, keyIn);
        } else {
            System.err.println("usage: SignedFileProcessor -v|-s [-a] file keyfile [passPhrase]");
        }
    }
}

