/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.server.cproc;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.MainArgsUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.server.LocalServer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerMain {
    private static Class<? extends LocalServer> localServerClass = LocalServer.class;
    private static final Logger logger = LoggerFactory.getLogger(LocalServerMain.class);

    protected LocalServerMain() {
    }

    public static void main(String[] args) throws Exception {
        LocalServerMain.initLogging();
        try {
            args = MainArgsUtil.extractAndApplySystemPropertiesReturnOthers((String[])args);
            LocalServer localServer = LocalServerMain.createLocalServer();
            localServer.setLocalServerStopFileEnabled(true);
            localServer.start();
        }
        catch (Throwable x) {
            logger.error(x.toString(), x);
            System.exit(999);
        }
    }

    public static Class<? extends LocalServer> getLocalServerClass() {
        return localServerClass;
    }

    public static void setLocalServerClass(Class<? extends LocalServer> localServerClass) {
        LocalServerMain.localServerClass = Objects.requireNonNull(localServerClass, "localServerClass");
    }

    protected static Constructor<? extends LocalServer> getLocalServerConstructor() throws NoSuchMethodException, SecurityException {
        Class<? extends LocalServer> clazz = LocalServerMain.getLocalServerClass();
        Constructor<? extends LocalServer> constructor = clazz.getConstructor(new Class[0]);
        return constructor;
    }

    protected static LocalServer createLocalServer() throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<? extends LocalServer> constructor = LocalServerMain.getLocalServerConstructor();
        LocalServer cloudStoreServer = constructor.newInstance(new Object[0]);
        return cloudStoreServer;
    }

    private static void initLogging() throws IOException, JoranException {
        File logDir = ConfigDir.getInstance().getLogDir();
        DerbyUtil.setLogFile((File)OioFileFactory.createFile((File)logDir, (String[])new String[]{"derby.log"}));
        String logbackXmlName = "logback.localserver.xml";
        File logbackXmlFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"logback.localserver.xml"});
        if (!logbackXmlFile.exists()) {
            AppIdRegistry.getInstance().copyResourceResolvingAppId(LocalServerMain.class, "logback.localserver.xml", logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile.getIoFile());
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        DebugUtil.logSystemProperties();
    }
}

