/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.LongUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoneMarker
implements Closeable {
    private static final String LOCAL_REVISION_FILE_NAME = "localRevision.bin";
    private static final Logger logger = LoggerFactory.getLogger(DoneMarker.class);
    private final File doneDir;

    public DoneMarker(File doneDir) {
        this.doneDir = Objects.requireNonNull(doneDir, "doneDir");
        if (doneDir.isFile()) {
            logger.error("doneDir '{}' is a normal file, but should be a directory. Deleting it now.", (Object)doneDir.getAbsolutePath());
            doneDir.deleteRecursively();
        }
        if (!doneDir.isDirectory()) {
            doneDir.mkdir();
            if (!doneDir.isDirectory()) {
                throw new RuntimeException(new IOException(String.format("Directory '%s' could not be created! Check permissions and available space/inodes.", doneDir.getAbsolutePath())));
            }
        }
    }

    public File getDoneDir() {
        return this.doneDir;
    }

    @Override
    public void close() {
    }

    public void markDone(long entityId, long localRevision) {
        String[] entityIdHexSegments = LongUtil.toBytesHex(entityId, true);
        File entityIdDir = this.doneDir;
        for (String segment : entityIdHexSegments) {
            if ((entityIdDir = entityIdDir.createFile(segment)).isDirectory()) continue;
            entityIdDir.mkdir();
            if (entityIdDir.isDirectory()) continue;
            throw new RuntimeException(new IOException(String.format("Directory '%s' could not be created! Check permissions and available space/inodes.", entityIdDir.getAbsolutePath())));
        }
        File localRevisionFile = entityIdDir.createFile(LOCAL_REVISION_FILE_NAME);
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(localRevisionFile.getIoFile()));){
            out.writeLong(localRevision);
        }
        catch (IOException x) {
            throw new RuntimeException(String.format("Failed writing file '%s'!", localRevisionFile.getAbsolutePath()), x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDone(long entityId, long localRevision) {
        String segment;
        String[] entityIdHexSegments = LongUtil.toBytesHex(entityId, true);
        File entityIdDir = this.doneDir;
        String[] stringArray = entityIdHexSegments;
        int n = stringArray.length;
        for (int n2 = 0; n2 < n; entityIdDir = entityIdDir.createFile(segment), ++n2) {
            segment = stringArray[n2];
        }
        if (!entityIdDir.isDirectory()) {
            return false;
        }
        File localRevisionFile = entityIdDir.createFile(LOCAL_REVISION_FILE_NAME);
        if (!localRevisionFile.isFile()) {
            return false;
        }
        if (localRevisionFile.length() < 8L) {
            logger.warn("isDone: File '{}' exists, but contains less than 8 bytes!", (Object)localRevisionFile.getAbsolutePath());
            return false;
        }
        try (DataInputStream in = new DataInputStream(new FileInputStream(localRevisionFile.getIoFile()));){
            long oldLocalRevision = in.readLong();
            if (oldLocalRevision == localRevision) {
                boolean bl = true;
                return bl;
            }
            logger.warn("isDone: Entity with id={} is already marked as done for localRevision={}, but not for localRevision={}, thus returning false.", new Object[]{entityId, oldLocalRevision, localRevision});
            return false;
        }
        catch (IOException x) {
            throw new RuntimeException(String.format("Failed reading file '%s'!", localRevisionFile.getAbsolutePath()), x);
        }
    }
}

