/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.ErrorStackTraceElement;
import co.codewizards.cloudstore.core.dto.RemoteException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public final class RemoteExceptionUtil {
    private RemoteExceptionUtil() {
    }

    public static void throwOriginalExceptionIfPossible(Error error) {
        Throwable throwable = RemoteExceptionUtil.toThrowable(error);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof java.lang.Error) {
            throw (java.lang.Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    private static Throwable toThrowable(Error error) {
        return RemoteExceptionUtil.toThrowable(error, false);
    }

    private static Throwable toThrowable(Error error, boolean nested) {
        Throwable throwable;
        block11: {
            Class<?> clazz;
            if (error == null) {
                return null;
            }
            Throwable cause = RemoteExceptionUtil.toThrowable(error.getCause(), true);
            try {
                clazz = Class.forName(error.getClassName());
            }
            catch (ClassNotFoundException e) {
                return new RemoteException(error, true).initCause(cause);
            }
            if (!Throwable.class.isAssignableFrom(clazz)) {
                return new RemoteException(error, true).initCause(cause);
            }
            Class<?> clasz = clazz;
            throwable = null;
            if (throwable == null) {
                throwable = (Throwable)RemoteExceptionUtil.getObjectOrNull(clasz, new Class[]{String.class, Throwable.class}, error.getMessage(), cause);
            }
            if (throwable == null) {
                throwable = (Throwable)RemoteExceptionUtil.getObjectOrNull(clasz, new Class[]{String.class}, error.getMessage());
            }
            if (throwable == null) {
                throwable = (Throwable)RemoteExceptionUtil.getObjectOrNull(clasz, new Class[]{Throwable.class}, cause);
            }
            if (throwable == null) {
                throwable = (Throwable)RemoteExceptionUtil.getObjectOrNull(clasz, null, new Object[0]);
            }
            if (throwable == null) {
                throwable = new RemoteException(error, true);
            }
            try {
                throwable.initCause(cause);
            }
            catch (Exception x) {
                if (throwable.getCause() == cause) break block11;
                return new RemoteException(error, true).initCause(cause);
            }
        }
        RemoteExceptionUtil.initStackTrace(throwable, error, nested);
        return throwable;
    }

    private static void initStackTrace(Throwable throwable, Error error, boolean replaceOriginalStackTrace) {
        Objects.requireNonNull(throwable, "throwable");
        Objects.requireNonNull(error, "error");
        int idx = -1;
        StackTraceElement[] origStackTrace = replaceOriginalStackTrace ? new StackTraceElement[]{} : throwable.getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[origStackTrace.length + error.getStackTraceElements().size()];
        for (ErrorStackTraceElement errorStackTraceElement : error.getStackTraceElements()) {
            stackTrace[++idx] = new StackTraceElement(errorStackTraceElement.getClassName(), errorStackTraceElement.getMethodName(), errorStackTraceElement.getFileName(), errorStackTraceElement.getLineNumber());
        }
        for (StackTraceElement stackTraceElement : origStackTrace) {
            stackTrace[++idx] = stackTraceElement;
        }
        throwable.setStackTrace(stackTrace);
    }

    private static <T> T getObjectOrNull(Class<T> clazz, Class<?>[] argumentTypes, Object ... arguments) {
        T result = null;
        if (argumentTypes == null) {
            argumentTypes = new Class[]{};
        }
        if (argumentTypes.length == 0) {
            try {
                result = clazz.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        if (result == null) {
            Constructor<T> constructor;
            try {
                constructor = clazz.getConstructor(argumentTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
            try {
                result = constructor.newInstance(arguments);
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
        }
        return result;
    }
}

