/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.sql.Timestamp;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class SqlTimestamp
extends Timestamp
implements SCO<Timestamp> {
    protected transient ObjectProvider ownerOP;
    protected transient AbstractMemberMetaData ownerMmd;

    public SqlTimestamp(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(0L);
        this.ownerOP = op;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise() {
    }

    @Override
    public void initialise(Timestamp ts, boolean forInsert, boolean forUpdate) {
        super.setTime(ts.getTime());
        super.setNanos(ts.getNanos());
    }

    @Override
    public Timestamp getValue() {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }

    @Override
    public void unsetOwner() {
        this.ownerOP = null;
        this.ownerMmd = null;
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
            if (!this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
    }

    @Override
    public Timestamp detachCopy(FetchPlanState state) {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }

    @Override
    public void attachCopy(Timestamp value) {
        long oldValue = this.getTime();
        this.initialise(value, false, true);
        long newValue = value.getTime();
        if (oldValue != newValue) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((SqlTimestamp)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.makeDirty();
    }

    @Override
    public void setNanos(int time_nanos) {
        super.setNanos(time_nanos);
        this.makeDirty();
    }

    @Override
    public void setYear(int year) {
        super.setYear(year);
        this.makeDirty();
    }

    @Override
    public void setMonth(int month) {
        super.setMonth(month);
        this.makeDirty();
    }

    @Override
    public void setDate(int date) {
        super.setDate(date);
        this.makeDirty();
    }

    @Override
    public void setHours(int hours) {
        super.setHours(hours);
        this.makeDirty();
    }

    @Override
    public void setMinutes(int minutes) {
        super.setMinutes(minutes);
        this.makeDirty();
    }

    @Override
    public void setSeconds(int seconds) {
        super.setSeconds(seconds);
        this.makeDirty();
    }

    protected Object writeReplace() throws ObjectStreamException {
        Timestamp ts = new Timestamp(this.getTime());
        ts.setNanos(this.getNanos());
        return ts;
    }
}

