/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server;

import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.exception.ApplicationException;
import co.codewizards.cloudstore.rest.server.CloudStoreRest;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionMapper.class);

    public DefaultExceptionMapper(@Context CloudStoreRest cloudStoreRest) {
        logger.debug("<init>: Instance created. cloudStoreRest={}", (Object)cloudStoreRest);
        if (cloudStoreRest == null) {
            throw new IllegalArgumentException("cloudStoreRest == null");
        }
    }

    public Response toResponse(Throwable throwable) {
        Throwable applicationException = this.getApplicationException(throwable);
        if (applicationException != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(throwable), throwable);
            } else {
                logger.info("toResponse: {} wrapped in {}. Enable debug-logging, if you need the stack-trace.", (Object)applicationException.getClass().getName(), (Object)throwable.getClass().getName());
            }
        } else {
            logger.error(String.valueOf(throwable), throwable);
        }
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        Error error = new Error(throwable);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/xml").entity((Object)error).build();
    }

    private Throwable getApplicationException(Throwable exception) {
        Objects.requireNonNull(exception, "exception");
        for (Throwable x = exception; x != null; x = x.getCause()) {
            ApplicationException appEx = x.getClass().getAnnotation(ApplicationException.class);
            if (appEx == null) continue;
            return x;
        }
        return null;
    }
}

