/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinEventType;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.tasks.impl.GpioEventDebounceTaskImpl;
import com.pi4j.io.gpio.tasks.impl.GpioEventDispatchTaskImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class GpioEventMonitorExecutorImpl
implements PinListener {
    private final GpioPinInput pin;
    private static ExecutorService executor;
    private static ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> debounceFuture = null;

    public GpioEventMonitorExecutorImpl(GpioPinInput pin) {
        this.pin = pin;
        executor = GpioFactory.getExecutorServiceFactory().getGpioEventExecutorService();
        scheduledExecutor = GpioFactory.getExecutorServiceFactory().getScheduledExecutorService();
    }

    @Override
    public void handlePinEvent(PinEvent event) {
        PinState state;
        GpioPinDigitalInput dip;
        int pinDebounceForState;
        if (this.pin instanceof GpioPinDigitalInput && event.getEventType() == PinEventType.DIGITAL_STATE_CHANGE && (pinDebounceForState = (dip = (GpioPinDigitalInput)this.pin).getDebounce(state = ((PinDigitalStateChangeEvent)event).getState())) > 0) {
            if (this.debounceFuture == null || this.debounceFuture.isDone()) {
                this.debounceFuture = scheduledExecutor.schedule(new GpioEventDebounceTaskImpl(dip, state), (long)pinDebounceForState, TimeUnit.MILLISECONDS);
            } else {
                return;
            }
        }
        executor.execute(new GpioEventDispatchTaskImpl(this.pin, event));
    }
}

