/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp;

import house.intelli.pgp.CompressionAlgorithm;
import house.intelli.pgp.HashAlgorithm;
import house.intelli.pgp.PgpAuthenticationCallback;
import house.intelli.pgp.PgpEncoder;
import house.intelli.pgp.PgpKey;
import house.intelli.pgp.PgpRegistry;
import house.intelli.pgp.SymmetricEncryptionAlgorithm;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractPgpEncoder
implements PgpEncoder {
    private InputStream inputStream;
    private OutputStream outputStream;
    private OutputStream signOutputStream;
    private final Set<PgpKey> encryptPgpKeys = new HashSet<PgpKey>(0);
    private PgpKey signPgpKey;
    private String fileName = "";
    private boolean withIntegrityCheck;
    private SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = SymmetricEncryptionAlgorithm.TWOFISH;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.ZIP;
    private HashAlgorithm hashAlgorithm = HashAlgorithm.SHA256;

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected InputStream getInputStreamOrFail() {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("inputStream == null");
        }
        return inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStream getOutputStreamOrFail() {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            throw new IllegalStateException("outputStream == null");
        }
        return outputStream;
    }

    @Override
    public OutputStream getSignOutputStream() {
        return this.signOutputStream;
    }

    @Override
    public void setSignOutputStream(OutputStream signOutputStream) {
        this.signOutputStream = signOutputStream;
    }

    @Override
    public boolean isWithIntegrityCheck() {
        return this.withIntegrityCheck;
    }

    @Override
    public void setWithIntegrityCheck(boolean withIntegrityCheck) {
        this.withIntegrityCheck = withIntegrityCheck;
    }

    @Override
    public SymmetricEncryptionAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    @Override
    public void setSymmetricEncryptionAlgorithm(SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm) {
        this.symmetricEncryptionAlgorithm = Objects.requireNonNull(symmetricEncryptionAlgorithm, "symmetricEncryptionAlgorithm");
    }

    @Override
    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        this.compressionAlgorithm = Objects.requireNonNull(compressionAlgorithm, "compressionAlgorithm");
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
    }

    @Override
    public Set<PgpKey> getEncryptPgpKeys() {
        return this.encryptPgpKeys;
    }

    @Override
    public PgpKey getSignPgpKey() {
        return this.signPgpKey;
    }

    @Override
    public void setSignPgpKey(PgpKey signPgpKey) {
        if (signPgpKey != null && !signPgpKey.isSecretKeyAvailable()) {
            throw new IllegalArgumentException("signPgpKey.privateKeyAvailable == false :: A private key is required for signing! signPgpKey.pgpKeyId=" + signPgpKey.getPgpKeyId() + ", signPgpKey.userIds=" + signPgpKey.getUserIds());
        }
        this.signPgpKey = signPgpKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = Objects.requireNonNull(fileName, "fileName");
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallback() {
        PgpAuthenticationCallback pgpAuthenticationCallback = PgpRegistry.getInstance().getPgpAuthenticationCallback();
        return pgpAuthenticationCallback;
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallbackOrFail() {
        PgpAuthenticationCallback pgpAuthenticationCallback = this.getPgpAuthenticationCallback();
        if (pgpAuthenticationCallback == null) {
            throw new IllegalStateException("There is no PgpAuthenticationCallback assigned!");
        }
        return pgpAuthenticationCallback;
    }
}

