/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp;

import house.intelli.core.bean.AbstractBean;
import house.intelli.core.bean.PropertyBase;
import house.intelli.core.observable.ObservableList;
import house.intelli.core.observable.standard.StandardPostModificationEvent;
import house.intelli.core.observable.standard.StandardPostModificationListener;
import house.intelli.pgp.PgpUserId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CreatePgpKeyParam
extends AbstractBean<Property>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<PgpUserId> _userIds = new ArrayList<PgpUserId>();
    private transient ObservableList<PgpUserId> userIds = ObservableList.decorate(this._userIds);
    private char[] passphrase;
    private long validitySeconds;
    private Algorithm algorithm;
    private int strength;

    public CreatePgpKeyParam() {
        this.userIds.getHandler().addPostModificationListener((Object)new PostModificationListener());
        this.passphrase = new char[0];
        this.validitySeconds = 315360000L;
        this.algorithm = Algorithm.RSA;
        this.strength = CreatePgpKeyParam.max(this.algorithm.getSupportedStrengths());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.userIds = ObservableList.decorate(this._userIds);
        this.userIds.getHandler().addPostModificationListener((Object)new PostModificationListener());
    }

    public ObservableList<PgpUserId> getUserIds() {
        return this.userIds;
    }

    public char[] getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(char[] passphrase) {
        this.setPropertyValue(PropertyEnum.passphrase, passphrase);
    }

    public long getValiditySeconds() {
        return this.validitySeconds;
    }

    public void setValiditySeconds(long validitySeconds) {
        if (validitySeconds < 0L) {
            throw new IllegalArgumentException("validitySeconds < 0");
        }
        this.setPropertyValue(PropertyEnum.validitySeconds, validitySeconds);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.setPropertyValue(PropertyEnum.algorithm, (Object)Objects.requireNonNull(algorithm, "algorithm"));
        if (!algorithm.isSupportedStrength(this.strength)) {
            this.setStrength(CreatePgpKeyParam.max(algorithm.getSupportedStrengths()));
        }
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        if (!this.algorithm.isSupportedStrength(strength)) {
            throw new IllegalArgumentException(String.format("strength=%s is not supported by algorithm %s!", new Object[]{strength, this.algorithm}));
        }
        this.setPropertyValue(PropertyEnum.strength, strength);
    }

    private static int max(List<Integer> values) {
        int result = Integer.MIN_VALUE;
        for (int v : values) {
            if (result >= v) continue;
            result = v;
        }
        return result;
    }

    public CreatePgpKeyParam toPortable() {
        CreatePgpKeyParam result = new CreatePgpKeyParam();
        for (PgpUserId pgpUserId : this._userIds) {
            result._userIds.add(new PgpUserId(pgpUserId));
        }
        result.passphrase = this.passphrase;
        result.validitySeconds = this.validitySeconds;
        result.algorithm = this.algorithm;
        result.strength = this.strength;
        return result;
    }

    public static enum Algorithm {
        RSA(1024, 2048, 4096),
        DSA_AND_EL_GAMAL(1024, 2048, 4096);

        private final List<Integer> supportedStrengths;

        private Algorithm(int ... supportedStrengths) {
            ArrayList<Integer> l = new ArrayList<Integer>(supportedStrengths.length);
            for (int supportedStrength : Objects.requireNonNull(supportedStrengths, "supportedStrengths")) {
                l.add(supportedStrength);
            }
            this.supportedStrengths = Collections.unmodifiableList(l);
        }

        public List<Integer> getSupportedStrengths() {
            return this.supportedStrengths;
        }

        public boolean isSupportedStrength(int strength) {
            return this.supportedStrengths.contains(strength);
        }
    }

    private class PostModificationListener
    implements StandardPostModificationListener {
        private PostModificationListener() {
        }

        public void modificationOccurred(StandardPostModificationEvent event) {
            CreatePgpKeyParam.this.firePropertyChange(PropertyEnum.userIds, null, CreatePgpKeyParam.this.getUserIds());
        }
    }

    public static enum PropertyEnum implements Property
    {
        userIds,
        passphrase,
        validitySeconds,
        algorithm,
        strength;

    }

    public static interface Property
    extends PropertyBase {
    }
}

