/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp;

import house.intelli.pgp.Messages;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum PgpSignatureType {
    BINARY_DOCUMENT(-1),
    CANONICAL_TEXT_DOCUMENT(-1),
    STAND_ALONE(-1),
    DEFAULT_CERTIFICATION(10),
    NO_CERTIFICATION(20),
    CASUAL_CERTIFICATION(30),
    POSITIVE_CERTIFICATION(40),
    SUBKEY_BINDING(-1),
    PRIMARYKEY_BINDING(-1),
    DIRECT_KEY(-1),
    KEY_REVOCATION(-1),
    SUBKEY_REVOCATION(-1),
    CERTIFICATION_REVOCATION(-1),
    TIMESTAMP(-1);

    private final int trustLevel;
    public static final Set<PgpSignatureType> CERTIFICATIONS;

    private PgpSignatureType(int trustLevel) {
        this.trustLevel = trustLevel;
    }

    public int getTrustLevel() {
        return this.trustLevel;
    }

    public boolean isCertification() {
        return CERTIFICATIONS.contains((Object)this);
    }

    public String toString() {
        return Messages.getString(String.format("PgpSignatureType[%s].string", this.name()));
    }

    public String toShortString() {
        return Messages.getString(String.format("PgpSignatureType[%s].shortString", this.name()));
    }

    public String getAnswer() {
        return Messages.getString(String.format("PgpSignatureType[%s].answer", this.name()));
    }

    public String getDescription() {
        return Messages.getString(String.format("PgpSignatureType[%s].description", this.name()));
    }

    static {
        CERTIFICATIONS = Collections.unmodifiableSet(EnumSet.of(DEFAULT_CERTIFICATION, NO_CERTIFICATION, CASUAL_CERTIFICATION, POSITIVE_CERTIFICATION));
    }
}

