/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp;

import house.intelli.pgp.PgpAuthenticationCallback;
import house.intelli.pgp.PgpKey;
import house.intelli.pgp.PgpKeyId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticPgpAuthenticationCallback
implements PgpAuthenticationCallback {
    private String defaultPassphrase;
    private Map<String, String> keyId2Passphrase = new HashMap<String, String>();
    private Map<String, String> userId2Passphrase = new HashMap<String, String>();
    private final Map<PgpKeyId, char[]> pgpKeyId2Passphrase = Collections.synchronizedMap(new HashMap());

    @Override
    public char[] getPassphrase(PgpKey pgpKey) {
        PgpKeyId pgpKeyId = pgpKey.getPgpKeyId();
        char[] passphrase = this.pgpKeyId2Passphrase.get(pgpKeyId);
        if (passphrase == null && !this.pgpKeyId2Passphrase.containsKey(pgpKeyId)) {
            passphrase = this.getPassphraseForKeyId(pgpKeyId.toHumanString());
            if (passphrase == null) {
                passphrase = this.getPassphraseForKeyId(pgpKeyId.toString());
            }
            if (passphrase == null) {
                passphrase = this.getPassphraseForUserId(pgpKey.getUserIds());
            }
            if (passphrase == null) {
                String p = this.getDefaultPassphrase();
                passphrase = p == null ? null : p.toCharArray();
            }
            this.pgpKeyId2Passphrase.put(pgpKeyId, passphrase);
        }
        return passphrase;
    }

    private char[] getPassphraseForUserId(List<String> userIds) {
        for (String userId : userIds) {
            String passphrase = this.userId2Passphrase.get(userId);
            if (passphrase == null) continue;
            return passphrase.toCharArray();
        }
        return null;
    }

    private char[] getPassphraseForKeyId(String keyId) {
        String passphrase = this.keyId2Passphrase.get(keyId);
        if (passphrase != null) {
            return passphrase.toCharArray();
        }
        return null;
    }

    public String getDefaultPassphrase() {
        return this.defaultPassphrase;
    }

    public void setDefaultPassphrase(String passphrase) {
        this.defaultPassphrase = passphrase;
    }

    public Map<String, String> getUserId2Passphrase() {
        return this.userId2Passphrase;
    }

    public void setUserId2Passphrase(Map<String, String> userId2Passphrase) {
        this.userId2Passphrase = new HashMap<String, String>(userId2Passphrase == null ? new HashMap() : userId2Passphrase);
    }

    public Map<String, String> getKeyId2Passphrase() {
        return this.keyId2Passphrase;
    }

    public void setKeyId2Passphrase(Map<String, String> keyId2Passphrase) {
        this.keyId2Passphrase = new HashMap<String, String>(keyId2Passphrase == null ? new HashMap() : keyId2Passphrase);
    }
}

