/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.pgp.rpc.SymmetricCryptoType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;

public class CipherManager {
    private static final CipherManager instance = new CipherManager();
    private final Map<SymmetricCryptoType, LinkedList<StreamCipher>> symmetricCryptoType2Ciphers = new HashMap<SymmetricCryptoType, LinkedList<StreamCipher>>();
    private final WeakHashMap<StreamCipher, SymmetricCryptoType> cipher2SymmetricCryptoType = new WeakHashMap();

    public static CipherManager getInstance() {
        return instance;
    }

    protected CipherManager() {
    }

    public synchronized StreamCipher acquireCipher(SymmetricCryptoType symmetricCryptoType) {
        StreamCipher cipher;
        Objects.requireNonNull(symmetricCryptoType, "symmetricCryptoType");
        LinkedList<Object> ciphers = this.symmetricCryptoType2Ciphers.get((Object)symmetricCryptoType);
        if (ciphers == null) {
            ciphers = new LinkedList();
            this.symmetricCryptoType2Ciphers.put(symmetricCryptoType, ciphers);
        }
        if ((cipher = ciphers.poll()) == null) {
            cipher = this.createCipher(symmetricCryptoType);
            this.cipher2SymmetricCryptoType.put(cipher, symmetricCryptoType);
        }
        return cipher;
    }

    public synchronized void releaseCipher(StreamCipher cipher) {
        Objects.requireNonNull(cipher, "cipher");
        SymmetricCryptoType symmetricCryptoType = this.cipher2SymmetricCryptoType.get(cipher);
        if (symmetricCryptoType == null) {
            throw new IllegalArgumentException("cipher unknown! Instance was not obtained from this manager via acquireCipher(...), before!");
        }
        LinkedList<StreamCipher> ciphers = this.symmetricCryptoType2Ciphers.get((Object)symmetricCryptoType);
        Objects.requireNonNull(ciphers, "ciphers");
        ciphers.add(cipher);
    }

    private StreamCipher createCipher(SymmetricCryptoType symmetricCryptoType) {
        AESEngine engine;
        switch (symmetricCryptoType) {
            case AES_CFB_NOPADDING: {
                engine = new AESEngine();
                break;
            }
            case TWOFISH_CFB_NOPADDING: {
                engine = new TwofishEngine();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown symmetricCryptoType: " + (Object)((Object)symmetricCryptoType));
            }
        }
        CFBBlockCipher streamCipher = new CFBBlockCipher((BlockCipher)engine, 8 * engine.getBlockSize());
        return streamCipher;
    }
}

