/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.HttpRpcClientTransport;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcMessage;
import house.intelli.core.util.Util;
import house.intelli.pgp.rpc.PgpRequest;
import house.intelli.pgp.rpc.PgpResponse;
import house.intelli.pgp.rpc.PgpTransportSupport;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpHttpRpcClientTransport
extends HttpRpcClientTransport {
    private static final Logger logger = LoggerFactory.getLogger(PgpHttpRpcClientTransport.class);
    private final PgpTransportSupport pgpTransportSupport = new PgpTransportSupport();

    public HostId getServerHostId() {
        return this.pgpTransportSupport.getServerHostId();
    }

    public void setServerHostId(HostId serverHostId) {
        this.pgpTransportSupport.setServerHostId(serverHostId);
    }

    public void sendRequest(Request<?> request) throws IOException {
        PgpRequest pgpRequest;
        Objects.requireNonNull(request, "request");
        if (request instanceof PgpRequest) {
            logger.debug("sendRequest: Relaying request: {}", request);
            pgpRequest = (PgpRequest)request;
        } else {
            logger.debug("sendRequest: Encrypting request: {}", request);
            pgpRequest = new PgpRequest();
            pgpRequest.copyRequestCoordinates((RpcMessage)request);
            pgpRequest.setRequestId(new Uid());
            byte[] plainRequest = this.pgpTransportSupport.serializeRpcMessage((RpcMessage)request);
            HostId serverHostId = this.pgpTransportSupport.resolveRealServerHostId(request.getServerHostId());
            HostId clientHostId = HostId.getLocalHostId();
            pgpRequest.setClientHostId(this.pgpTransportSupport.resolveAliasHostId(clientHostId));
            pgpRequest.setEncryptedRequest(this.pgpTransportSupport.encryptAndSign(plainRequest, clientHostId, serverHostId));
            logger.debug("sendRequest: Encrypted request: {}", (Object)pgpRequest);
        }
        super.sendRequest((Request)pgpRequest);
    }

    public Response receiveResponse() throws IOException {
        Response res = super.receiveResponse();
        Objects.requireNonNull(res, "res");
        this.pgpTransportSupport.handleSessionNotFoundException(res);
        HostId serverHostId = this.pgpTransportSupport.resolveRealServerHostId(res.getServerHostId());
        HostId clientHostId = this.pgpTransportSupport.resolveRealServerHostId(res.getClientHostId());
        if (clientHostId.equals((Object)this.getRpcContext().getLocalHostId())) {
            if (res instanceof ErrorResponse) {
                logger.debug("receiveResponse: Returning error-response directly: {}", (Object)res);
                return res;
            }
            logger.debug("receiveResponse: Decrypting response: {}", (Object)res);
            PgpResponse pgpResponse = (PgpResponse)res;
            byte[] plainResponse = this.pgpTransportSupport.decryptAndVerifySignature(pgpResponse.getEncryptedResponse(), serverHostId, clientHostId);
            RpcMessage rpcMessage = this.pgpTransportSupport.deserializeRpcMessage(plainResponse);
            Response response = (Response)rpcMessage;
            logger.debug("receiveResponse: Decrypted response: {}", (Object)response);
            this.pgpTransportSupport.handleSessionNotFoundException(response);
            if (!Util.equal((Object)pgpResponse.getClientHostId(), (Object)response.getClientHostId())) {
                throw new IOException(String.format("pgpResponse.clientHostId != response.clientHostId :: %s != %s", pgpResponse.getClientHostId(), response.getClientHostId()));
            }
            if (!Util.equal((Object)pgpResponse.getServerHostId(), (Object)response.getServerHostId())) {
                if (response instanceof ErrorResponse && HostId.SERVER.equals((Object)pgpResponse.getServerHostId())) {
                    return response;
                }
                throw new IOException(String.format("pgpResponse.serverHostId != response.serverHostId :: %s != %s", pgpResponse.getServerHostId(), response.getServerHostId()));
            }
            return response;
        }
        logger.debug("receiveResponse: Relaying response: {}", (Object)res);
        return res;
    }
}

