/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.HttpRpcClientTransportProvider;
import house.intelli.core.rpc.RpcClientTransport;
import house.intelli.pgp.rpc.PgpHttpRpcClientTransport;
import house.intelli.pgp.rpc.PgpRequestService;
import java.net.URL;
import java.util.Objects;

public class PgpHttpRpcClientTransportProvider
extends HttpRpcClientTransportProvider {
    private HostId serverHostId;

    public synchronized HostId getServerHostId() {
        return this.serverHostId;
    }

    public synchronized void setServerHostId(HostId serverHostId) {
        this.serverHostId = serverHostId;
        if (serverHostId != null) {
            PgpRequestService.setServerHostId(serverHostId);
        }
    }

    protected RpcClientTransport _createRpcClientTransport() {
        this.resolveServerHostIdIfNeeded();
        URL serverUrl = Objects.requireNonNull(this.getActualServerUrl(), "serverUrl");
        PgpHttpRpcClientTransport result = new PgpHttpRpcClientTransport();
        result.setServerUrl(serverUrl);
        result.setServerHostId(this.getServerHostId());
        return result;
    }

    private void resolveServerHostIdIfNeeded() {
        if (this.getServerHostId() == null) {
            String host = Objects.requireNonNull(this.getServerUrl(), "serverUrl").getHost();
            this.setServerHostId(new HostId(host));
        }
    }
}

