/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.HttpRpcServerTransport;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcMessage;
import house.intelli.core.util.Util;
import house.intelli.pgp.rpc.PgpRequest;
import house.intelli.pgp.rpc.PgpResponse;
import house.intelli.pgp.rpc.PgpTransportSupport;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpHttpRpcServerTransport
extends HttpRpcServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(PgpHttpRpcServerTransport.class);
    private final PgpTransportSupport pgpTransportSupport = new PgpTransportSupport();
    private Request<?> rawRequest;

    public Request<?> receiveRequest() throws IOException {
        HostId localHostId = this.getRpcContext().getLocalHostId();
        this.pgpTransportSupport.setServerHostId(localHostId);
        Request req = super.receiveRequest();
        this.setRawRequest(Objects.requireNonNull(req, "req"));
        HostId serverHostId = this.pgpTransportSupport.resolveRealServerHostId(req.getServerHostId());
        HostId clientHostId = this.pgpTransportSupport.resolveRealServerHostId(req.getClientHostId());
        if (serverHostId.equals((Object)localHostId)) {
            logger.debug("receiveRequest: Decrypting request: {}", (Object)req);
            if (!(req instanceof PgpRequest)) {
                throw new IllegalStateException("Client sent plain-text request: " + req);
            }
            PgpRequest pgpRequest = (PgpRequest)req;
            byte[] plainRequest = this.pgpTransportSupport.decryptAndVerifySignature(pgpRequest.getEncryptedRequest(), clientHostId, serverHostId);
            RpcMessage rpcMessage = this.pgpTransportSupport.deserializeRpcMessage(plainRequest);
            Request request = (Request)rpcMessage;
            logger.debug("receiveRequest: Decrypted request: {}", (Object)request);
            if (!Util.equal((Object)pgpRequest.getClientHostId(), (Object)request.getClientHostId())) {
                throw new IOException(String.format("pgpRequest.clientHostId != rawRequest.clientHostId :: %s != %s", pgpRequest.getClientHostId(), request.getClientHostId()));
            }
            if (!Util.equal((Object)pgpRequest.getServerHostId(), (Object)request.getServerHostId())) {
                throw new IOException(String.format("pgpRequest.serverHostId != rawRequest.serverHostId :: %s != %s", pgpRequest.getServerHostId(), request.getServerHostId()));
            }
            return request;
        }
        logger.debug("receiveRequest: Relaying request: {}", (Object)req);
        return req;
    }

    public void sendResponse(Response response) throws IOException {
        PgpResponse pgpResponse;
        Objects.requireNonNull(response, "response");
        Request<?> rawRequest = this.getRawRequest();
        if (rawRequest != null) {
            response.copyRequestCoordinates(rawRequest);
        }
        if (!(rawRequest instanceof PgpRequest)) {
            if (!(response instanceof ErrorResponse)) {
                throw new IllegalStateException("response should be an ErrorResponse when the client attempts to communicate unencrypted data!");
            }
            super.sendResponse(response);
            return;
        }
        HostId localHostId = this.getRpcContext().getLocalHostId();
        this.pgpTransportSupport.setServerHostId(localHostId);
        if (response instanceof PgpResponse) {
            logger.debug("sendResponse: Relaying response: {}", (Object)response);
            pgpResponse = (PgpResponse)response;
        } else {
            logger.debug("sendResponse: Encrypting response: {}", (Object)response);
            try {
                pgpResponse = new PgpResponse();
                pgpResponse.copyRequestCoordinates((RpcMessage)response);
                byte[] plainResponse = this.pgpTransportSupport.serializeRpcMessage((RpcMessage)response);
                HostId clientHostId = this.pgpTransportSupport.resolveRealServerHostId(response.getClientHostId());
                HostId serverHostId = localHostId;
                pgpResponse.setServerHostId(this.pgpTransportSupport.resolveAliasHostId(serverHostId));
                pgpResponse.setEncryptedResponse(this.pgpTransportSupport.encryptAndSign(plainResponse, serverHostId, clientHostId));
                logger.debug("sendResponse: Encrypted response: {}", (Object)pgpResponse);
            }
            catch (Exception x) {
                logger.error("sendResponse: " + x + ' ', (Throwable)x);
                throw x;
            }
        }
        super.sendResponse((Response)pgpResponse);
    }

    protected void setRawRequest(Request<?> request) {
        if (this.rawRequest != null) {
            throw new IllegalStateException("this.request already assigned!");
        }
        this.rawRequest = Objects.requireNonNull(request, "rawRequest");
    }

    protected Request<?> getRawRequest() {
        return this.rawRequest;
    }
}

