/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.DeferringResponse;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcMessage;
import house.intelli.core.rpc.RpcServiceExecutor;
import house.intelli.core.util.Util;
import house.intelli.pgp.rpc.PgpRequest;
import house.intelli.pgp.rpc.PgpResponse;
import house.intelli.pgp.rpc.PgpTransportSupport;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpRequestService
extends AbstractRpcService<PgpRequest, PgpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PgpRequestService.class);
    private static HostId serverHostId;
    private final PgpTransportSupport pgpTransportSupport = new PgpTransportSupport();

    public PgpRequestService() {
        this.pgpTransportSupport.setServerHostId(serverHostId);
    }

    public static HostId getServerHostId() {
        return serverHostId;
    }

    public static void setServerHostId(HostId serverHostId) {
        PgpRequestService.serverHostId = serverHostId;
    }

    public PgpResponse process(PgpRequest req) throws Exception {
        Response response;
        HostId localHostId = this.getRpcContext().getLocalHostId();
        RpcServiceExecutor rpcServiceExecutor = this.getRpcContext().getRpcServiceExecutor();
        HostId serverHostId = this.pgpTransportSupport.resolveRealServerHostId(req.getServerHostId());
        HostId clientHostId = this.pgpTransportSupport.resolveRealServerHostId(req.getClientHostId());
        if (serverHostId.equals((Object)localHostId)) {
            logger.debug("process: Decrypting request: {}", (Object)req);
            byte[] plainRequest = this.pgpTransportSupport.decryptAndVerifySignature(req.getEncryptedRequest(), clientHostId, serverHostId);
            RpcMessage rpcMessage = this.pgpTransportSupport.deserializeRpcMessage(plainRequest);
            Request request = (Request)rpcMessage;
            logger.debug("process: Decrypted request: {}", (Object)request);
            if (!Util.equal((Object)req.getClientHostId(), (Object)request.getClientHostId())) {
                throw new IOException(String.format("pgpRequest.clientHostId != rawRequest.clientHostId :: %s != %s", req.getClientHostId(), request.getClientHostId()));
            }
            if (!Util.equal((Object)req.getServerHostId(), (Object)request.getServerHostId())) {
                throw new IOException(String.format("pgpRequest.serverHostId != rawRequest.serverHostId :: %s != %s", req.getServerHostId(), request.getServerHostId()));
            }
            rpcServiceExecutor.putRequest(request);
            response = rpcServiceExecutor.pollResponse(request.getRequestId(), request.getTimeout());
            if (response == null) {
                response = new DeferringResponse();
                response.copyRequestCoordinates((RpcMessage)request);
            }
        } else {
            logger.debug("process: Relaying request: {}", (Object)req);
            rpcServiceExecutor.putRequest((Request)req);
            response = rpcServiceExecutor.pollResponse(req.getRequestId(), req.getTimeout());
            if (response == null) {
                response = new DeferringResponse();
                response.copyRequestCoordinates((RpcMessage)req);
            }
        }
        if (response instanceof PgpResponse) {
            return (PgpResponse)response;
        }
        logger.debug("process: Encrypting response: {}", (Object)response);
        try {
            PgpResponse pgpResponse = new PgpResponse();
            pgpResponse.copyRequestCoordinates((RpcMessage)response);
            byte[] plainResponse = this.pgpTransportSupport.serializeRpcMessage((RpcMessage)response);
            serverHostId = localHostId;
            pgpResponse.setServerHostId(this.pgpTransportSupport.resolveAliasHostId(serverHostId));
            pgpResponse.setEncryptedResponse(this.pgpTransportSupport.encryptAndSign(plainResponse, serverHostId, clientHostId));
            logger.debug("process: Encrypted response: {}", (Object)pgpResponse);
            return pgpResponse;
        }
        catch (Exception x) {
            logger.error("process: " + x + ' ', (Throwable)x);
            throw x;
        }
    }
}

