/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.Uid;
import house.intelli.core.auth.SignatureException;
import house.intelli.core.jaxb.IntelliHouseJaxbContext;
import house.intelli.core.rpc.Error;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcMessage;
import house.intelli.pgp.Pgp;
import house.intelli.pgp.PgpDecoder;
import house.intelli.pgp.PgpEncoder;
import house.intelli.pgp.PgpKey;
import house.intelli.pgp.PgpKeyValidity;
import house.intelli.pgp.PgpRegistry;
import house.intelli.pgp.PgpSignature;
import house.intelli.pgp.rpc.CipherManager;
import house.intelli.pgp.rpc.CipherWithIv;
import house.intelli.pgp.rpc.HashType;
import house.intelli.pgp.rpc.Session;
import house.intelli.pgp.rpc.SessionHostIdPair;
import house.intelli.pgp.rpc.SessionManager;
import house.intelli.pgp.rpc.SessionNotFoundException;
import house.intelli.pgp.rpc.SessionRequest;
import house.intelli.pgp.rpc.SymmetricCryptoType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpTransportSupport {
    private static final Logger logger = LoggerFactory.getLogger(PgpTransportSupport.class);
    private HostId serverHostId;
    private JAXBContext jaxbContext;
    private static final SymmetricCryptoType symmetricCryptoType = SymmetricCryptoType.TWOFISH_CFB_NOPADDING;
    private static final HashType hashType = HashType.SHA256;
    private final Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
    private final Map<String, PgpKey> hostIdStr2PgpKey = new HashMap<String, PgpKey>();
    private static final SecureRandom random = Session.random;
    public static final byte[] ENCRYPTED_DATA_HEADER = new byte[]{105, 116, 108, 105, 104, 115};
    public static final byte ENCRYPTED_DATA_VERSION = 0;
    public static final byte ENCRYPTED_DATA_MODE_PGP = 0;
    public static final byte ENCRYPTED_DATA_MODE_SYMMETRIC = 1;

    public HostId getServerHostId() {
        return this.serverHostId;
    }

    public void setServerHostId(HostId serverHostId) {
        this.serverHostId = serverHostId;
    }

    public HostId resolveRealServerHostId(HostId hostId) {
        if (hostId == null) {
            return null;
        }
        HostId serverHostId = Objects.requireNonNull(this.getServerHostId(), "serverHostId");
        if (HostId.SERVER.equals((Object)hostId)) {
            return serverHostId;
        }
        return hostId;
    }

    public HostId resolveAliasHostId(HostId hostId) {
        if (hostId == null) {
            return null;
        }
        HostId serverHostId = Objects.requireNonNull(this.getServerHostId(), "serverHostId");
        if (serverHostId.equals((Object)hostId)) {
            return HostId.SERVER;
        }
        return hostId;
    }

    public PgpKey getMasterKeyOrFail(HostId hostId) {
        Objects.requireNonNull(hostId, "hostId");
        PgpKey masterKey = this.getMasterKey(hostId);
        if (masterKey == null) {
            throw new IllegalArgumentException(String.format("No PGP key found for hostId='%s'!", hostId));
        }
        return masterKey;
    }

    public PgpKey getMasterKey(HostId hostId) {
        Objects.requireNonNull(hostId, "hostId");
        Date now = new Date();
        if (this.hostIdStr2PgpKey.isEmpty()) {
            for (PgpKey pgpKey : this.pgp.getMasterKeys()) {
                if (!pgpKey.isValid(now)) {
                    logger.info("getMasterKey: Ignoring non-valid key: {}", (Object)pgpKey);
                    continue;
                }
                for (String userId : pgpKey.getUserIds()) {
                    String hostIdStr = userId.trim();
                    this.hostIdStr2PgpKey.put(hostIdStr, pgpKey);
                }
            }
        }
        String hostIdStr = hostId.toString();
        return this.hostIdStr2PgpKey.get(hostIdStr);
    }

    public byte[] serializeRpcMessage(RpcMessage rpcMessage) throws IOException {
        Objects.requireNonNull(rpcMessage, "rpcMessage");
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (GZIPOutputStream gzOut = new GZIPOutputStream(bout);){
                Marshaller marshaller = this.getJaxbContext().createMarshaller();
                marshaller.marshal((Object)rpcMessage, (OutputStream)gzOut);
            }
            return bout.toByteArray();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RpcMessage deserializeRpcMessage(byte[] serialized) throws IOException {
        Objects.requireNonNull(serialized, "serialized");
        try (GZIPInputStream gzIn = new GZIPInputStream(new ByteArrayInputStream(serialized));){
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)gzIn);
            RpcMessage rpcMessage = (RpcMessage)object;
            return rpcMessage;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public byte[] encryptAndSign(byte[] plainData, HostId senderHostId, HostId recipientHostId) throws IOException {
        Objects.requireNonNull(plainData, "plainData");
        Objects.requireNonNull(senderHostId, "senderHostId");
        Objects.requireNonNull(recipientHostId, "recipientHostId");
        long startTimestampTotal = System.currentTimeMillis();
        SessionHostIdPair sessionHostIdPair = new SessionHostIdPair(senderHostId, recipientHostId);
        SessionManager sessionManager = SessionManager.getInstance();
        Session session = sessionManager.getOrCreateSession(sessionHostIdPair);
        session.confirmByHostId(senderHostId);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(ENCRYPTED_DATA_HEADER);
        dout.write(0);
        logger.debug("encryptAndSign: session={}", (Object)session);
        if (session.isConfirmedCompletely()) {
            dout.writeByte(1);
            dout.writeInt(symmetricCryptoType.ordinal());
            PgpTransportSupport.writeShortByteArray(dout, session.getSessionId().toBytes());
            CipherWithIv cipherWithIv = PgpTransportSupport.acquireInitializedCipherForEncryption(symmetricCryptoType, session.getSessionKey());
            PgpTransportSupport.writeShortByteArray(dout, cipherWithIv.iv);
            byte[] plainDataWithHash = PgpTransportSupport.combinePlainDataWithHash(plainData);
            byte[] enc = new byte[plainDataWithHash.length * 3 / 2];
            long startTimestampEncode = System.currentTimeMillis();
            int encLen = cipherWithIv.cipher.processBytes(plainDataWithHash, 0, plainDataWithHash.length, enc, 0);
            long stopTimestampEncode = System.currentTimeMillis();
            PgpTransportSupport.writeLongByteArray(dout, enc, 0, encLen);
            PgpTransportSupport.releaseCipher(cipherWithIv);
            if (logger.isDebugEnabled()) {
                logger.debug("encryptAndSign: mode=SYMMETRIC, encodeDuration={}ms, totalDuration={}ms", (Object)(stopTimestampEncode - startTimestampEncode), (Object)(System.currentTimeMillis() - startTimestampTotal));
            }
        } else {
            dout.writeByte(0);
            byte[] sessionRequestBytes = this.serializeSessionRequest(session);
            ByteArrayOutputStream plainDataBout = new ByteArrayOutputStream();
            DataOutputStream plainDataDout = new DataOutputStream(plainDataBout);
            PgpTransportSupport.writeLongByteArray(plainDataDout, sessionRequestBytes);
            PgpTransportSupport.writeLongByteArray(plainDataDout, plainData);
            long startTimestampLookupPgpKeyForSenderHostId = System.currentTimeMillis();
            PgpKey senderKey = this.getMasterKeyOrFail(senderHostId);
            long stopTimestampLookupPgpKeyForSenderHostId = System.currentTimeMillis();
            long startTimestampLookupPgpKeyForRecipientHostId = System.currentTimeMillis();
            PgpKey recipientKey = this.getMasterKeyOrFail(recipientHostId);
            long stopTimestampLookupPgpKeyForRecipientHostId = System.currentTimeMillis();
            PgpEncoder encoder = this.pgp.createEncoder(new ByteArrayInputStream(plainDataBout.toByteArray()), dout);
            encoder.setSignPgpKey(senderKey);
            encoder.getEncryptPgpKeys().add(recipientKey);
            long startTimestampEncode = System.currentTimeMillis();
            encoder.encode();
            long stopTimestampEncode = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("encryptAndSign: mode=PGP, lookupSenderKeyDuration={}ms, lookupRecipientKeyDuration={}ms, encodeDuration={}ms, totalDuration={}ms", new Object[]{stopTimestampLookupPgpKeyForSenderHostId - startTimestampLookupPgpKeyForSenderHostId, stopTimestampLookupPgpKeyForRecipientHostId - startTimestampLookupPgpKeyForRecipientHostId, stopTimestampEncode - startTimestampEncode, System.currentTimeMillis() - startTimestampTotal});
            }
        }
        return bout.toByteArray();
    }

    public byte[] decryptAndVerifySignature(byte[] encryptedData, HostId senderHostId, HostId recipientHostId) throws IOException {
        Objects.requireNonNull(encryptedData, "encryptedData");
        Objects.requireNonNull(senderHostId, "senderHostId");
        Objects.requireNonNull(recipientHostId, "recipientHostId");
        long startTimestampTotal = System.currentTimeMillis();
        SessionManager sessionManager = SessionManager.getInstance();
        ByteArrayInputStream bin = new ByteArrayInputStream(encryptedData);
        DataInputStream din = new DataInputStream(bin);
        byte[] header = new byte[ENCRYPTED_DATA_HEADER.length];
        din.readFully(header);
        if (!Arrays.equals(ENCRYPTED_DATA_HEADER, header)) {
            throw new IllegalArgumentException(String.format("Header illegal! expected=%s, found=%s", Arrays.toString(ENCRYPTED_DATA_HEADER), Arrays.toString(header)));
        }
        byte version = din.readByte();
        if (0 != version) {
            throw new IllegalArgumentException(String.format("Version illegal! expected=%s, found=%s", (byte)0, version));
        }
        byte mode = din.readByte();
        if (1 == mode) {
            int symmetricCryptoTypeOrdinal = din.readInt();
            SymmetricCryptoType symmetricCryptoType = SymmetricCryptoType.values()[symmetricCryptoTypeOrdinal];
            Uid sessionId = new Uid(PgpTransportSupport.readShortByteArray(din));
            Session session = sessionManager.getSessionOrFail(sessionId);
            logger.debug("decryptAndVerifySignature: session={}", (Object)session);
            session.confirmByHostId(senderHostId);
            byte[] iv = PgpTransportSupport.readShortByteArray(din);
            byte[] enc = PgpTransportSupport.readLongByteArray(din);
            byte[] buf = new byte[enc.length * 3 / 2];
            StreamCipher cipher = PgpTransportSupport.acquireInitializedCipherForDecryption(symmetricCryptoType, session.getSessionKey(), iv);
            long startTimestampDecode = System.currentTimeMillis();
            int plainDataWithHashLength = cipher.processBytes(enc, 0, enc.length, buf, 0);
            long stopTimestampDecode = System.currentTimeMillis();
            PgpTransportSupport.releaseCipher(cipher);
            byte[] plainDataWithHash = new byte[plainDataWithHashLength];
            System.arraycopy(buf, 0, plainDataWithHash, 0, plainDataWithHashLength);
            byte[] plainData = PgpTransportSupport.splitPlainDataFromHashWithVerification(plainDataWithHash);
            if (logger.isDebugEnabled()) {
                logger.debug("decryptAndVerifySignature: mode=SYMMETRIC, decodeDuration={}ms, totalDuration={}ms", (Object)(stopTimestampDecode - startTimestampDecode), (Object)(System.currentTimeMillis() - startTimestampTotal));
            }
            return plainData;
        }
        if (0 == mode) {
            ByteArrayInputStream plainDataBin;
            DataInputStream plainDataDin;
            byte[] sessionRequestBytes;
            SessionRequest sessionRequest;
            Session session;
            ByteArrayOutputStream plainDataBout = new ByteArrayOutputStream();
            PgpDecoder decoder = this.pgp.createDecoder(din, plainDataBout);
            long startTimestampDecode = System.currentTimeMillis();
            try {
                decoder.decode();
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
            long stopTimestampDecode = System.currentTimeMillis();
            PgpSignature signature = decoder.getPgpSignature();
            if (signature == null) {
                throw new IOException("encryptedData was not signed!");
            }
            long startTimestampLookupPgpKey = System.currentTimeMillis();
            PgpKey pgpKey = this.pgp.getPgpKey(signature.getPgpKeyId());
            if (pgpKey == null) {
                throw new IOException(String.format("encryptedData was signed by *unknown* key %s!", signature.getPgpKeyId().toHumanString()));
            }
            long stopTimestampLookupPgpKey = System.currentTimeMillis();
            List<String> userIds = pgpKey.getUserIds();
            if (!userIds.contains(senderHostId.toString())) {
                throw new IOException(String.format("encryptedData was signed by key '%s' which does not have the userId '%s' associated! userIds of this key are: %s", signature.getPgpKeyId().toHumanString(), senderHostId, userIds));
            }
            PgpKeyValidity minimumKeyValidity = PgpKeyValidity.FULL;
            PgpKeyValidity keyValidity = this.pgp.getKeyValidity(pgpKey);
            if (minimumKeyValidity.compareTo(keyValidity) > 0) {
                throw new IOException(String.format("encryptedData was signed by key '%s' (userId '%s'), which is not trusted/valid! minimumKeyValidity=%s, foundKeyValidity=%s", new Object[]{signature.getPgpKeyId().toHumanString(), senderHostId, minimumKeyValidity, keyValidity}));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("decryptAndVerifySignature: mode=PGP, decodeDuration={}ms, lookupKeyDuration={}ms, totalDuration={}ms", new Object[]{stopTimestampDecode - startTimestampDecode, stopTimestampLookupPgpKey - startTimestampLookupPgpKey, System.currentTimeMillis() - startTimestampTotal});
            }
            if ((session = sessionManager.getSession((sessionRequest = this.deserializeSessionRequest(sessionRequestBytes = PgpTransportSupport.readLongByteArray(plainDataDin = new DataInputStream(plainDataBin = new ByteArrayInputStream(plainDataBout.toByteArray()))))).getSessionId())) == null) {
                session = sessionRequest.createSession();
                session.confirmByHostId(senderHostId);
                session.confirmByHostId(recipientHostId);
                logger.debug("decryptAndVerifySignature: enlisted new session={}", (Object)session);
                sessionManager.putSession(session);
            } else {
                logger.debug("decryptAndVerifySignature: found and confirmed session={}", (Object)session);
                if (!Arrays.equals(session.getSessionKey(), sessionRequest.getSessionKey())) {
                    throw new IllegalArgumentException("localSession.sessionKey != sessionRequest.sessionKey");
                }
                if (!session.getSessionHostIdPair().equals(sessionRequest.getSessionHostIdPair())) {
                    throw new IllegalArgumentException(String.format("localSession.sessionHostIdPair != sessionRequest.sessionHostIdPair :: %s != %s", session.getSessionHostIdPair(), sessionRequest.getSessionHostIdPair()));
                }
                session.confirmByHostId(senderHostId);
            }
            byte[] plainData = PgpTransportSupport.readLongByteArray(plainDataDin);
            return plainData;
        }
        throw new IllegalArgumentException(String.format("Mode illegal! expected=(%s|%s), found=%s", (byte)1, (byte)0, mode));
    }

    public void handleSessionNotFoundException(Response response) {
        if (!(response instanceof ErrorResponse)) {
            return;
        }
        ErrorResponse errorResponse = (ErrorResponse)response;
        Uid sessionId = this.getSessionNotFoundExceptionSessionId(errorResponse.getError());
        if (sessionId == null) {
            return;
        }
        SessionManager sessionManager = SessionManager.getInstance();
        sessionManager.removeSession(sessionId);
    }

    private Uid getSessionNotFoundExceptionSessionId(Error error) {
        Class<?> clazz;
        if (error == null) {
            return null;
        }
        try {
            clazz = Class.forName(error.getClassName());
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        if (clazz != null && SessionNotFoundException.class.isAssignableFrom(clazz)) {
            return SessionManager.getSessionIdFromSessionNotFoundExceptionMessage(error.getMessage());
        }
        return this.getSessionNotFoundExceptionSessionId(error.getCause());
    }

    private byte[] serializeSessionRequest(Session session) throws IOException {
        Objects.requireNonNull(session, "session");
        try {
            ByteArrayOutputStream sessionRequestOut = new ByteArrayOutputStream();
            this.getJaxbContext().createMarshaller().marshal((Object)new SessionRequest(session), (OutputStream)sessionRequestOut);
            return sessionRequestOut.toByteArray();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private SessionRequest deserializeSessionRequest(byte[] sessionRequestBytes) throws IOException {
        Objects.requireNonNull(sessionRequestBytes, "sessionRequestBytes");
        try {
            Object deserialized = this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(sessionRequestBytes));
            return (SessionRequest)deserialized;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private static void writeLongByteArray(DataOutputStream dout, byte[] byteArray) throws IOException {
        Objects.requireNonNull(dout, "dout");
        Objects.requireNonNull(byteArray, "byteArray");
        dout.writeInt(byteArray.length);
        dout.write(byteArray);
    }

    private static void writeLongByteArray(DataOutputStream dout, byte[] byteArray, int offset, int length) throws IOException {
        Objects.requireNonNull(dout, "dout");
        Objects.requireNonNull(byteArray, "byteArray");
        dout.writeInt(length);
        dout.write(byteArray, offset, length);
    }

    private static void writeShortByteArray(DataOutputStream dout, byte[] byteArray) throws IOException {
        Objects.requireNonNull(dout, "dout");
        Objects.requireNonNull(byteArray, "byteArray");
        if (byteArray.length > 255) {
            throw new IllegalStateException("byteArray.length > 255");
        }
        dout.writeByte(byteArray.length);
        dout.write(byteArray);
    }

    private static byte[] readLongByteArray(DataInputStream din) throws IOException {
        Objects.requireNonNull(din, "din");
        int byteArrayLength = din.readInt();
        byte[] byteArray = new byte[byteArrayLength];
        din.readFully(byteArray);
        return byteArray;
    }

    private static byte[] readShortByteArray(DataInputStream din) throws IOException {
        Objects.requireNonNull(din, "din");
        int byteArrayLength = din.readByte() & 0xFF;
        byte[] byteArray = new byte[byteArrayLength];
        din.readFully(byteArray);
        return byteArray;
    }

    protected JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            this.jaxbContext = IntelliHouseJaxbContext.getJaxbContext();
        }
        return this.jaxbContext;
    }

    private static CipherWithIv acquireInitializedCipherForEncryption(SymmetricCryptoType symmetricCryptoType, byte[] key) {
        Objects.requireNonNull(symmetricCryptoType, "symmetricCryptoType");
        Objects.requireNonNull(key, "key");
        StreamCipher cipher = CipherManager.getInstance().acquireCipher(symmetricCryptoType);
        byte[] iv = new byte[PgpTransportSupport.getIvSize(cipher)];
        random.nextBytes(iv);
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV params = new ParametersWithIV((CipherParameters)kp, iv);
        cipher.init(true, (CipherParameters)params);
        return new CipherWithIv(cipher, iv);
    }

    private static StreamCipher acquireInitializedCipherForDecryption(SymmetricCryptoType symmetricCryptoType, byte[] key, byte[] iv) {
        Objects.requireNonNull(symmetricCryptoType, "symmetricCryptoType");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(iv, "iv");
        StreamCipher cipher = CipherManager.getInstance().acquireCipher(symmetricCryptoType);
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV params = new ParametersWithIV((CipherParameters)kp, iv);
        cipher.init(false, (CipherParameters)params);
        return cipher;
    }

    private static void releaseCipher(CipherWithIv cipherWithIv) {
        Objects.requireNonNull(cipherWithIv, "cipherWithIv");
        PgpTransportSupport.releaseCipher(cipherWithIv.cipher);
    }

    private static void releaseCipher(StreamCipher cipher) {
        Objects.requireNonNull(cipher, "cipher");
        CipherManager.getInstance().releaseCipher(cipher);
    }

    protected static byte[] sha256(byte[] in) {
        Objects.requireNonNull(in, "in");
        SHA256Digest digest = new SHA256Digest();
        byte[] out = new byte[digest.getDigestSize()];
        digest.update(in, 0, in.length);
        digest.doFinal(out, 0);
        return out;
    }

    protected static byte[] combinePlainDataWithHash(byte[] plainData) throws IOException {
        Objects.requireNonNull(plainData, "in");
        ByteArrayOutputStream bout = new ByteArrayOutputStream(plainData.length + 128);
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(hashType.ordinal());
        PgpTransportSupport.writeLongByteArray(dout, plainData);
        PgpTransportSupport.writeShortByteArray(dout, PgpTransportSupport.sha256(plainData));
        return bout.toByteArray();
    }

    protected static byte[] splitPlainDataFromHashWithVerification(byte[] in) throws IOException {
        byte[] foundHash;
        Objects.requireNonNull(in, "in");
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(in));
        int hashTypeOrdinal = din.readInt();
        if (hashTypeOrdinal < 0) {
            throw new IOException("hashTypeOrdinal < 0!!! hashTypeOrdinal=" + hashTypeOrdinal);
        }
        if (hashTypeOrdinal >= HashType.values().length) {
            throw new IOException("hashTypeOrdinal >= HashType.values.length!!! hashTypeOrdinal=" + hashTypeOrdinal);
        }
        HashType hashType = HashType.values()[hashTypeOrdinal];
        byte[] plainData = PgpTransportSupport.readLongByteArray(din);
        byte[] declaredHash = PgpTransportSupport.readShortByteArray(din);
        switch (hashType) {
            case SHA256: {
                foundHash = PgpTransportSupport.sha256(plainData);
                break;
            }
            default: {
                throw new UnsupportedOperationException("hashType: " + (Object)((Object)hashType));
            }
        }
        if (!Arrays.equals(declaredHash, foundHash)) {
            throw new IOException("Data corruption: Declared hash does not match found hash!!!");
        }
        return plainData;
    }

    protected static int getIvSize(StreamCipher cipher) {
        Objects.requireNonNull(cipher, "cipher");
        if (cipher instanceof BlockCipher) {
            return ((BlockCipher)cipher).getBlockSize();
        }
        throw new UnsupportedOperationException("cipher is not an instance of BlockCipher! Not yet supported: " + cipher.getClass().getName());
    }
}

