/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.HostId;
import house.intelli.pgp.rpc.SessionHostIdPair;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Session {
    protected static final SecureRandom random = new SecureRandom();
    public static final long SESSION_MAX_AGE = 86400000L;
    public static final int SESSION_KEY_SIZE = 256;
    private final Uid sessionId;
    private final SessionHostIdPair sessionHostIdPair;
    private final byte[] sessionKey;
    private final Date created;
    private final Set<HostId> confirmedByHostIds = Collections.synchronizedSet(new HashSet(2));

    private static byte[] createSessionKey() {
        byte[] sessionKey = new byte[32];
        random.nextBytes(sessionKey);
        return sessionKey;
    }

    public Session(SessionHostIdPair sessionHostIdPair) {
        this(new Uid(), sessionHostIdPair, Session.createSessionKey(), new Date());
    }

    public Session(Uid sessionId, SessionHostIdPair sessionHostIdPair, byte[] sessionKey, Date created) {
        this.sessionHostIdPair = Objects.requireNonNull(sessionHostIdPair, "sessionHostIdPair");
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
        this.sessionKey = Objects.requireNonNull(sessionKey, "sessionKey");
        if (sessionKey.length < 16) {
            throw new IllegalArgumentException("sessionKey too short!");
        }
        this.created = Objects.requireNonNull(created, "created");
    }

    public Set<HostId> getConfirmedByHostIds() {
        return Collections.unmodifiableSet(this.confirmedByHostIds);
    }

    public void confirmByHostId(HostId hostId) {
        Objects.requireNonNull(hostId, "hostId");
        if (this.confirmedByHostIds.contains(hostId)) {
            return;
        }
        if (!this.sessionHostIdPair.getHostIds().contains(hostId)) {
            throw new IllegalStateException(String.format("Session %s is owned by %s! Cannot confirm by %s!", this.sessionId, this.sessionHostIdPair.getHostIds(), hostId));
        }
        this.confirmedByHostIds.add(hostId);
    }

    public boolean isConfirmedCompletely() {
        return this.confirmedByHostIds.equals(this.sessionHostIdPair.getHostIds());
    }

    public Uid getSessionId() {
        return this.sessionId;
    }

    public SessionHostIdPair getSessionHostIdPair() {
        return this.sessionHostIdPair;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public Date getCreated() {
        return this.created;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "sessionId=" + this.sessionId + ", sessionHostIdPair=" + this.sessionHostIdPair + ", created=" + this.created + ", confirmedByHostIds=" + this.confirmedByHostIds;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.created.getTime() > 86400000L;
    }
}

