/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.rpc.HostId;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class SessionHostIdPair {
    private final HostId hostId0;
    private final HostId hostId1;
    private transient Set<HostId> hostIds;

    public final Set<HostId> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new LinkedHashSet<HostId>(Arrays.asList(this.hostId0, this.hostId1));
        }
        return this.hostIds;
    }

    public SessionHostIdPair(HostId ... hostIds) {
        if (Objects.requireNonNull(hostIds, "hostIds").length != 2) {
            throw new IllegalArgumentException("hostIdslength != 2");
        }
        Objects.requireNonNull(hostIds[0], "hostIds[0]");
        Objects.requireNonNull(hostIds[1], "hostIds[1]");
        if (hostIds[0].compareTo(hostIds[1]) < 0) {
            this.hostId0 = hostIds[0];
            this.hostId1 = hostIds[1];
        } else {
            this.hostId0 = hostIds[1];
            this.hostId1 = hostIds[0];
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hostId0.hashCode();
        result = 31 * result + this.hostId1.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionHostIdPair other = (SessionHostIdPair)obj;
        return this.hostId0.equals((Object)other.hostId0) && this.hostId1.equals((Object)other.hostId1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "hostId0=" + this.hostId0 + ", hostId1=" + this.hostId1;
    }
}

