/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.pgp.rpc;

import house.intelli.core.Uid;
import house.intelli.pgp.rpc.Session;
import house.intelli.pgp.rpc.SessionHostIdPair;
import house.intelli.pgp.rpc.SessionNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static final long EVICT_PERIOD = 1800000L;
    private static final long EVICT_ADDITIONAL_AGE = 900000L;
    private static final SessionManager instance = new SessionManager();
    private final Map<Uid, Session> sessionId2Session = new HashMap<Uid, Session>();
    private final Map<SessionHostIdPair, Session> sessionHostIdPair2Session = new HashMap<SessionHostIdPair, Session>();
    private final Timer evictTimer = new Timer("SessionManager.evictTimer", true);
    private final TimerTask evictTimerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                SessionManager.this.evict();
            }
            catch (Throwable x) {
                logger.error("evictTimerTask.run: " + x + ' ', x);
            }
        }
    };
    private static final String SESSION_NOT_FOUND_EXCEPTION_MESSAGE_PREFIX = "There is no session with sessionId=";

    public static SessionManager getInstance() {
        return instance;
    }

    protected SessionManager() {
        this.evictTimer.schedule(this.evictTimerTask, 1800000L, 1800000L);
    }

    public synchronized Session getSession(Uid sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        return this.sessionId2Session.get(sessionId);
    }

    public synchronized Session getOrCreateSession(SessionHostIdPair sessionHostIdPair) {
        Session session = this.getSession(sessionHostIdPair);
        if (session == null || session.isExpired()) {
            session = new Session(sessionHostIdPair);
            logger.debug("getOrCreateSession: created: {}", (Object)session);
            this.putSession(session);
        } else {
            logger.debug("getOrCreateSession: found: {}", (Object)session);
        }
        return session;
    }

    public synchronized Session getSession(SessionHostIdPair sessionHostIdPair) {
        Objects.requireNonNull(sessionHostIdPair, "sessionHostIdPair");
        return this.sessionHostIdPair2Session.get(sessionHostIdPair);
    }

    public synchronized void putSession(Session session) {
        Objects.requireNonNull(session, "session");
        this.sessionId2Session.put(session.getSessionId(), session);
        this.sessionHostIdPair2Session.put(session.getSessionHostIdPair(), session);
        logger.debug("putSession: {}", (Object)session);
    }

    public synchronized boolean removeSession(Uid sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        Session session = this.sessionId2Session.remove(sessionId);
        if (session != null) {
            this.sessionHostIdPair2Session.remove(session.getSessionHostIdPair());
            return true;
        }
        return false;
    }

    public Session getSessionOrFail(Uid sessionId) throws SessionNotFoundException {
        Objects.requireNonNull(sessionId, "sessionId");
        Session session = this.getSession(sessionId);
        if (session == null) {
            throw new SessionNotFoundException(SESSION_NOT_FOUND_EXCEPTION_MESSAGE_PREFIX + sessionId);
        }
        return session;
    }

    public static Uid getSessionIdFromSessionNotFoundExceptionMessage(String message) {
        Objects.requireNonNull(message, "message");
        if (!message.startsWith(SESSION_NOT_FOUND_EXCEPTION_MESSAGE_PREFIX)) {
            throw new IllegalArgumentException(String.format("message does not start with prefix '%s'!", SESSION_NOT_FOUND_EXCEPTION_MESSAGE_PREFIX));
        }
        String sessionIdString = message.substring(SESSION_NOT_FOUND_EXCEPTION_MESSAGE_PREFIX.length());
        return new Uid(sessionIdString);
    }

    protected synchronized void evict() {
        Date oldestSessionCreatedNotYetEvicted = new Date(System.currentTimeMillis() - 86400000L - 900000L);
        HashSet<Uid> evictedSessionIds = new HashSet<Uid>();
        Iterator<Map.Entry<Uid, Session>> it = this.sessionId2Session.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Uid, Session> me = it.next();
            Session session = me.getValue();
            if (!session.getCreated().before(oldestSessionCreatedNotYetEvicted)) continue;
            evictedSessionIds.add(session.getSessionId());
            it.remove();
            this.sessionHostIdPair2Session.remove(session.getSessionHostIdPair());
        }
        logger.info("evict: evictedSessionIds={}", evictedSessionIds);
    }
}

