/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class TimeInterval
implements Comparable<TimeInterval> {
    private final Date fromIncl;
    private final Date toExcl;
    private static SimpleDateFormat iso8601DateFormat;

    public TimeInterval(Date fromIncl, Date toExcl) {
        this.fromIncl = Objects.requireNonNull(fromIncl, "fromIncl");
        this.toExcl = Objects.requireNonNull(toExcl, "toExcl");
    }

    public Date getFromIncl() {
        return this.fromIncl;
    }

    public Date getToExcl() {
        return this.toExcl;
    }

    public long getLengthMillis() {
        return this.toExcl.getTime() - this.fromIncl.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Class<TimeInterval> clazz = TimeInterval.class;
        synchronized (TimeInterval.class) {
            if (iso8601DateFormat == null) {
                iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            }
            String fromStr = iso8601DateFormat.format(this.fromIncl);
            String toStr = iso8601DateFormat.format(this.toExcl);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return "TimeInterval[" + fromStr + ',' + toStr + ")";
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromIncl.hashCode();
        result = 31 * result + this.toExcl.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return this.fromIncl.equals(other.fromIncl) && this.toExcl.equals(other.toExcl);
    }

    @Override
    public int compareTo(TimeInterval o) {
        return this.fromIncl.compareTo(o.fromIncl);
    }
}

