/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.bean;

import house.intelli.core.bean.PropertyBase;
import house.intelli.core.util.ReflectionUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSupport<B, P extends PropertyBase> {
    private static final Logger logger = LoggerFactory.getLogger(BeanSupport.class);
    private final B bean;
    private final PropertyChangeSupport propertyChangeSupport;
    private boolean getBeanNameMethodDoesNotExist;
    private Method getBeanNameMethod;

    public BeanSupport(B bean) {
        this.bean = Objects.requireNonNull(bean, "bean");
        this.propertyChangeSupport = new PropertyChangeSupport(bean);
    }

    public B getBean() {
        return this.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPropertyValue(P property, Object value) {
        Object old;
        Objects.requireNonNull(property, "property");
        Object object = this.getMutex();
        synchronized (object) {
            old = ReflectionUtil.getFieldValue(this.bean, property.name());
            if (this.isEqual(property, old, value)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setPropertyValue: ignoring: bean={} property={} old=value={}", new Object[]{this.getBeanInstanceName(), property, value});
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setPropertyValue: setting: bean={} property={} old={} value={}", new Object[]{this.getBeanInstanceName(), property, old, value});
            }
            ReflectionUtil.setFieldValue(this.bean, property.name(), value);
        }
        this.firePropertyChange(property, old, value);
        return true;
    }

    public String getBeanInstanceName() {
        String beanName = this.getBeanName();
        if (beanName == null) {
            return this.bean.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this.bean));
        }
        return this.bean.getClass().getSimpleName() + '[' + beanName + ']' + '@' + Integer.toHexString(System.identityHashCode(this.bean));
    }

    public String getBeanName() {
        Method getBeanNameMethod = this.getGetBeanNameMethod();
        if (getBeanNameMethod == null) {
            return null;
        }
        try {
            return (String)getBeanNameMethod.invoke(this.bean, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    private Method getGetBeanNameMethod() {
        if (this.getBeanNameMethodDoesNotExist) {
            return null;
        }
        Method getBeanNameMethod = this.getBeanNameMethod;
        if (getBeanNameMethod == null) {
            getBeanNameMethod = ReflectionUtil.getDeclaredMethod(this.bean.getClass(), "getBeanName", null);
            if (getBeanNameMethod == null) {
                this.getBeanNameMethodDoesNotExist = true;
                return null;
            }
            if (String.class != getBeanNameMethod.getReturnType()) {
                this.getBeanNameMethodDoesNotExist = true;
                return null;
            }
            this.getBeanNameMethod = getBeanNameMethod;
        }
        return getBeanNameMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V getPropertyValue(P property) {
        Object object = this.getMutex();
        synchronized (object) {
            return ReflectionUtil.getFieldValue(this.bean, property.name());
        }
    }

    protected Object getMutex() {
        return this.bean;
    }

    protected boolean isEqual(P property, Object oldValue, Object newValue) {
        return oldValue == null ? newValue == null : oldValue.equals(newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(P property, PropertyChangeListener listener) {
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    public void removePropertyChangeListener(P property, PropertyChangeListener listener) {
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(listener, "listener");
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    public void firePropertyChange(P property, Object oldValue, Object newValue) {
        Objects.requireNonNull(property, "property");
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }
}

