/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.config;

import house.intelli.core.util.IOUtil;
import house.intelli.core.util.StringUtil;
import java.io.File;

public class ConfigDir {
    public static final String APP_ID_SIMPLE_ID = "intellihouse";
    public static final String SYSTEM_PROPERTY_CONFIG_DIR = "intellihouse.configDir";
    public static final String SYSTEM_PROPERTY_LOG_DIR = "intellihouse.logDir";
    private final String value;
    private final File file;
    private File logDir;

    protected ConfigDir() {
        String v = System.getProperty(SYSTEM_PROPERTY_CONFIG_DIR);
        if (v == null) {
            v = "${user.home}/.intellihouse";
        }
        this.value = v;
        System.setProperty(SYSTEM_PROPERTY_CONFIG_DIR, this.value);
        String resolvedValue = IOUtil.replaceTemplateVariables(this.value, System.getProperties());
        this.file = new File(resolvedValue).getAbsoluteFile();
        if (!this.file.isDirectory()) {
            this.file.mkdirs();
        }
        if (!this.file.isDirectory()) {
            throw new IllegalStateException("Could not create directory (permissions?!): " + this.file);
        }
    }

    public static ConfigDir getInstance() {
        return ConfigDirHolder.instance;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public File getLogDir() {
        if (this.logDir == null) {
            String sysPropVal = System.getProperty(SYSTEM_PROPERTY_LOG_DIR);
            if (StringUtil.isEmpty(sysPropVal)) {
                this.logDir = new File(this.getFile(), "log");
            } else {
                String resolvedSysPropVal = IOUtil.replaceTemplateVariables(sysPropVal, System.getProperties());
                this.logDir = new File(resolvedSysPropVal).getAbsoluteFile();
            }
            System.setProperty(SYSTEM_PROPERTY_LOG_DIR, this.logDir.getPath());
            if (!this.logDir.isDirectory()) {
                this.logDir.mkdirs();
            }
            if (!this.logDir.isDirectory()) {
                throw new IllegalStateException("Could not create directory (permissions?!): " + this.logDir);
            }
        }
        return this.logDir;
    }

    private static final class ConfigDirHolder {
        public static ConfigDir instance = new ConfigDir();

        private ConfigDirHolder() {
        }
    }
}

