/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.io;

import house.intelli.core.io.LockFile;
import house.intelli.core.io.LockFileImpl;
import house.intelli.core.io.LockFileProxy;
import house.intelli.core.io.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFileFactory {
    private static final Logger logger = LoggerFactory.getLogger(LockFileFactory.class);
    private final Object mutex = this;
    private final Map<File, LockFileImpl> file2LockFileImpl = new HashMap<File, LockFileImpl>();

    protected LockFileFactory() {
    }

    public static LockFileFactory getInstance() {
        return LockFileFactoryHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockFile acquire(File file, long timeoutMillis) throws TimeoutException {
        Object object;
        LockFileImpl lockFileImpl;
        Objects.requireNonNull(file, "file");
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object object2 = this.mutex;
        synchronized (object2) {
            lockFileImpl = this.file2LockFileImpl.get(file);
            if (lockFileImpl == null) {
                lockFileImpl = new LockFileImpl(this, file);
                this.file2LockFileImpl.put(file, lockFileImpl);
                logger.trace("acquire: Adding file='{}' lockFileImpl={}", (Object)file, (Object)lockFileImpl);
            }
            ++lockFileImpl.acquireRunningCounter;
        }
        boolean exceptionThrown = true;
        try {
            lockFileImpl.acquire(timeoutMillis);
            exceptionThrown = false;
            object = this.mutex;
        }
        catch (Throwable throwable) {
            Object object3 = this.mutex;
            synchronized (object3) {
                int lockCounter = lockFileImpl.getLockCounter();
                int acquireRunningCounter = --lockFileImpl.acquireRunningCounter;
                if (lockCounter < 1 && acquireRunningCounter < 1) {
                    logger.trace("acquire: Removing lockFileImpl={}", (Object)lockFileImpl);
                    LockFileImpl removed = this.file2LockFileImpl.remove(file);
                    if (removed != lockFileImpl) {
                        throw new IllegalStateException(String.format("file2LockFileImpl.remove(file) != lockFileImpl :: %s != %s", removed, lockFileImpl));
                    }
                }
                if (lockCounter < 1 && !exceptionThrown) {
                    throw new IllegalStateException("lockCounter < 1, but no exception thrown!");
                }
            }
            throw throwable;
        }
        synchronized (object) {
            int lockCounter = lockFileImpl.getLockCounter();
            int acquireRunningCounter = --lockFileImpl.acquireRunningCounter;
            if (lockCounter < 1 && acquireRunningCounter < 1) {
                logger.trace("acquire: Removing lockFileImpl={}", (Object)lockFileImpl);
                LockFileImpl removed = this.file2LockFileImpl.remove(file);
                if (removed != lockFileImpl) {
                    throw new IllegalStateException(String.format("file2LockFileImpl.remove(file) != lockFileImpl :: %s != %s", removed, lockFileImpl));
                }
            }
            if (lockCounter < 1 && !exceptionThrown) {
                throw new IllegalStateException("lockCounter < 1, but no exception thrown!");
            }
        }
        return new LockFileProxy(lockFileImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postRelease(LockFileImpl lockFileImpl) {
        Object object = this.mutex;
        synchronized (object) {
            LockFileImpl lockFileImpl2 = this.file2LockFileImpl.get(lockFileImpl.getFile());
            if (lockFileImpl != lockFileImpl2) {
                throw new IllegalArgumentException(String.format("Unknown lockFileImpl instance (not managed by this registry)! file2LockFileImpl.get(lockFileImpl.getFile()) != lockFileImpl :: %s != %s ", lockFileImpl2, lockFileImpl));
            }
            int lockCounter = lockFileImpl.getLockCounter();
            int acquireRunningCounter = lockFileImpl.acquireRunningCounter;
            if (lockCounter < 1 && acquireRunningCounter < 1) {
                logger.trace("postRelease: Removing lockFileImpl={}", (Object)lockFileImpl);
                LockFileImpl removed = this.file2LockFileImpl.remove(lockFileImpl.getFile());
                if (removed != lockFileImpl) {
                    throw new IllegalStateException(String.format("file2LockFileImpl.remove(file) != lockFileImpl :: %s != %s", removed, lockFileImpl));
                }
            }
        }
    }

    private static class LockFileFactoryHolder {
        public static final LockFileFactory instance = new LockFileFactory();

        private LockFileFactoryHolder() {
        }
    }
}

