/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.jaxb;

import house.intelli.core.jaxb.IntelliHouseJaxbContextProvider;
import house.intelli.core.service.ServiceRegistry;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelliHouseJaxbContext {
    private static final Logger logger = LoggerFactory.getLogger(IntelliHouseJaxbContext.class);
    private static volatile JAXBContext jaxbContext;

    public static JAXBContext getJaxbContext() {
        JAXBContext result = jaxbContext;
        if (result == null) {
            HashSet collectedClassesToBeBound = new HashSet();
            ServiceRegistry<IntelliHouseJaxbContextProvider> serviceRegistry = ServiceRegistry.getInstance(IntelliHouseJaxbContextProvider.class);
            serviceRegistry.addListener(event -> IntelliHouseJaxbContext.reset());
            for (IntelliHouseJaxbContextProvider provider : serviceRegistry.getServices()) {
                Class<?>[] classesToBeBound = provider.getClassesToBeBound();
                logger.info("getJaxbContext: provider.class={}, classesToBeBound={}", (Object)provider.getClass().getName(), classesToBeBound);
                if (classesToBeBound == null) continue;
                for (Class<?> clazz : classesToBeBound) {
                    collectedClassesToBeBound.add(clazz);
                }
            }
            try {
                Class[] ca = collectedClassesToBeBound.toArray(new Class[collectedClassesToBeBound.size()]);
                jaxbContext = result = JAXBContext.newInstance((Class[])ca);
            }
            catch (JAXBException x) {
                throw new RuntimeException(x);
            }
        }
        return result;
    }

    public static void reset() {
        jaxbContext = null;
    }
}

