/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.observable;

import house.intelli.core.observable.ModificationHandlerFactory;
import house.intelli.core.observable.ObservableCollection;
import java.util.Collection;

public class ModificationHandler<E> {
    static final ModificationHandlerFactory FACTORY = new Factory();
    private ObservableCollection<E> obsCollection = null;
    private Collection<E> baseCollection = null;
    private final ModificationHandler<E> rootHandler;
    private final int viewOffset;

    protected ModificationHandler() {
        this.rootHandler = this;
        this.viewOffset = 0;
    }

    protected ModificationHandler(ModificationHandler<E> rootHandler, int viewOffset) {
        this.rootHandler = rootHandler;
        this.viewOffset = viewOffset;
    }

    void init(ObservableCollection<E> coll, Collection<E> baseColl) {
        if (coll == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        if (baseColl == null) {
            throw new IllegalArgumentException("Base Collection must not be null");
        }
        if (this.obsCollection != null) {
            throw new IllegalArgumentException("init() has already been called");
        }
        this.obsCollection = coll;
        this.baseCollection = baseColl;
    }

    public ObservableCollection<E> getObservedCollection() {
        return this.obsCollection;
    }

    protected Collection<E> getBaseCollection() {
        return this.baseCollection;
    }

    protected ModificationHandler<E> getRootHandler() {
        return this.rootHandler;
    }

    protected int getViewOffset() {
        return this.viewOffset;
    }

    public Object[] getPreModificationListeners() {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    public void addPreModificationListener(Object listener) {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    public void removePreModificationListener(Object listener) {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    public Object[] getPostModificationListeners() {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    public void addPostModificationListener(Object listener) {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    public void removePostModificationListener(Object listener) {
        throw new UnsupportedOperationException("Listeners not supported by " + this.getClass().getName());
    }

    protected boolean preEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection<E> view, int viewOffset) {
        return true;
    }

    protected void postEvent(boolean modified, int type, int index, Object object, int repeat, Object previous, ObservableCollection<E> view, int viewOffset) {
    }

    protected boolean preAdd(Object object) {
        return this.preEvent(1, -1, object, 1, null, null, -1);
    }

    protected void postAdd(Object object, boolean result) {
        this.postEvent(result, 1, -1, object, 1, null, null, -1);
    }

    protected boolean preAddIndexed(int index, Object object) {
        return this.preEvent(2, index + this.viewOffset, object, 1, null, null, -1);
    }

    protected void postAddIndexed(int index, Object object) {
        this.postEvent(true, 2, index + this.viewOffset, object, 1, null, null, -1);
    }

    protected boolean preAddNCopies(Object object, int nCopies) {
        return this.preEvent(4, -1, object, nCopies, null, null, -1);
    }

    protected void postAddNCopies(Object object, int nCopies, boolean result) {
        this.postEvent(true, 4, -1, object, nCopies, null, null, -1);
    }

    protected boolean preAddIterated(int index, Object object) {
        return this.preEvent(8, index + this.viewOffset, object, 1, null, null, -1);
    }

    protected void postAddIterated(int index, Object object) {
        this.postEvent(true, 8, index + this.viewOffset, object, 1, null, null, -1);
    }

    protected boolean preAddAll(Collection<? extends E> coll) {
        return this.preEvent(16, -1, coll, 1, null, null, -1);
    }

    protected void postAddAll(Collection<? extends E> coll, boolean collChanged) {
        this.postEvent(collChanged, 16, -1, coll, 1, null, null, -1);
    }

    protected boolean preAddAllIndexed(int index, Collection<? extends E> coll) {
        return this.preEvent(32, index + this.viewOffset, coll, 1, null, null, -1);
    }

    protected void postAddAllIndexed(int index, Collection<? extends E> coll, boolean collChanged) {
        this.postEvent(collChanged, 32, index + this.viewOffset, coll, 1, null, null, -1);
    }

    protected boolean preClear() {
        return this.preEvent(32768, -1, null, 1, null, null, -1);
    }

    protected void postClear() {
        this.postEvent(true, 32768, -1, null, 1, null, null, -1);
    }

    protected boolean preRemove(Object object) {
        return this.preEvent(256, -1, object, 1, null, null, -1);
    }

    protected void postRemove(Object object, boolean collChanged) {
        this.postEvent(collChanged, 256, -1, object, 1, collChanged ? object : null, null, -1);
    }

    protected boolean preRemoveIndexed(int index) {
        return this.preEvent(512, index + this.viewOffset, null, 1, null, null, -1);
    }

    protected void postRemoveIndexed(int index, Object previousValue) {
        this.postEvent(true, 512, index + this.viewOffset, null, 1, previousValue, null, -1);
    }

    protected boolean preRemoveNCopies(Object object, int nCopies) {
        return this.preEvent(1024, -1, object, nCopies, null, null, -1);
    }

    protected void postRemoveNCopies(Object object, int nCopies, boolean collChanged) {
        this.postEvent(collChanged, 1024, -1, object, nCopies, collChanged ? object : null, null, -1);
    }

    protected boolean preRemoveNext() {
        return this.preEvent(2048, -1, null, 1, null, null, -1);
    }

    protected void postRemoveNext(Object removedValue) {
        this.postEvent(true, 2048, -1, removedValue, 1, removedValue, null, -1);
    }

    protected boolean preRemoveIterated(int index, Object removedValue) {
        return this.preEvent(4096, index + this.viewOffset, removedValue, 1, removedValue, null, -1);
    }

    protected void postRemoveIterated(int index, Object removedValue) {
        this.postEvent(true, 4096, index + this.viewOffset, removedValue, 1, removedValue, null, -1);
    }

    protected boolean preRemoveAll(Collection<?> coll) {
        return this.preEvent(8192, -1, coll, 1, null, null, -1);
    }

    protected void postRemoveAll(Collection<?> coll, boolean collChanged) {
        this.postEvent(collChanged, 8192, -1, coll, 1, null, null, -1);
    }

    protected boolean preRetainAll(Collection<?> coll) {
        return this.preEvent(16384, -1, coll, 1, null, null, -1);
    }

    protected void postRetainAll(Collection<?> coll, boolean collChanged) {
        this.postEvent(collChanged, 16384, -1, coll, 1, null, null, -1);
    }

    protected boolean preSetIndexed(int index, Object object) {
        return this.preEvent(65536, index + this.viewOffset, object, 1, null, null, -1);
    }

    protected void postSetIndexed(int index, Object object, Object previousValue) {
        this.postEvent(object != previousValue, 65536, index + this.viewOffset, object, 1, previousValue, null, -1);
    }

    protected boolean preSetIterated(int index, Object object, Object previousValue) {
        return this.preEvent(131072, index + this.viewOffset, object, 1, previousValue, null, -1);
    }

    protected void postSetIterated(int index, Object object, Object previousValue) {
        this.postEvent(object != previousValue, 131072, index + this.viewOffset, object, 1, previousValue, null, -1);
    }

    protected ModificationHandler createSubSetHandler(Object fromElement, Object toElement) {
        return new SetViewHandler(this.rootHandler);
    }

    protected ModificationHandler createHeadSetHandler(Object toElement) {
        return new SetViewHandler(this.rootHandler);
    }

    protected ModificationHandler createTailSetHandler(Object fromElement) {
        return new SetViewHandler(this.rootHandler);
    }

    protected ModificationHandler createSubListHandler(int fromIndex, int toIndex) {
        return new SubListHandler((ModificationHandler)this.rootHandler, fromIndex + this.viewOffset);
    }

    public String toString() {
        String name = this.getClass().getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        return name + '[' + (this.obsCollection == null ? "" : "initialised") + ']';
    }

    static class Factory
    implements ModificationHandlerFactory {
        Factory() {
        }

        @Override
        public ModificationHandler createHandler(Collection coll, Object listener) {
            if (listener instanceof ModificationHandler) {
                return (ModificationHandler)listener;
            }
            return null;
        }
    }

    protected static class SubListHandler
    extends ModificationHandler {
        protected SubListHandler(ModificationHandler rootHandler, int viewOffset) {
            super(rootHandler, viewOffset);
        }

        protected boolean preEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection ignoredView, int ignoredOffset) {
            return this.getRootHandler().preEvent(type, index, object, repeat, previous, this.getObservedCollection(), this.getViewOffset());
        }

        protected void postEvent(boolean modified, int type, int index, Object object, int repeat, Object previous, ObservableCollection ignoredView, int ignoredOffset) {
            this.getRootHandler().postEvent(modified, type, index, object, repeat, previous, this.getObservedCollection(), this.getViewOffset());
        }
    }

    protected static class SetViewHandler
    extends ModificationHandler {
        protected SetViewHandler(ModificationHandler rootHandler) {
            super(rootHandler, 0);
        }

        protected boolean preEvent(int type, int index, Object object, int repeat, Object previous, ObservableCollection ignoredView, int offset) {
            return this.getRootHandler().preEvent(type, index, object, repeat, previous, this.getObservedCollection(), offset);
        }

        protected void postEvent(boolean modified, int type, int index, Object object, int repeat, Object previous, ObservableCollection ignoredView, int offset) {
            this.getRootHandler().postEvent(modified, type, index, object, repeat, previous, this.getObservedCollection(), offset);
        }
    }
}

