/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.observable;

import house.intelli.core.observable.ModificationHandler;
import house.intelli.core.observable.ModificationHandlerFactory;
import house.intelli.core.observable.standard.StandardModificationHandler;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections4.collection.AbstractCollectionDecorator;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;

public class ObservableCollection<E>
extends AbstractCollectionDecorator<E> {
    private static final long serialVersionUID = 1L;
    private static ModificationHandlerFactory[] factories = new ModificationHandlerFactory[]{ModificationHandler.FACTORY, StandardModificationHandler.FACTORY};
    protected final ModificationHandler<E> handler;

    public static <E> ObservableCollection<E> decorate(Collection<E> coll) {
        return new ObservableCollection<E>(coll, null);
    }

    public static <E> ObservableCollection<E> decorate(Collection<E> coll, Object listener) {
        if (coll == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        return new ObservableCollection<E>(coll, listener);
    }

    public static void registerFactory(ModificationHandlerFactory factory) {
        if (factory != null) {
            ModificationHandlerFactory[] array = new ModificationHandlerFactory[factories.length + 1];
            System.arraycopy(factories, 0, array, 0, factories.length);
            array[ObservableCollection.factories.length] = factory;
            factories = array;
        }
    }

    protected ObservableCollection(Collection<E> coll, Object listener) {
        super(coll);
        this.handler = this.createHandler(coll, listener);
        this.handler.init(this, coll);
    }

    protected ObservableCollection(ModificationHandler handler, Collection<E> coll) {
        super(coll);
        this.handler = handler;
    }

    protected ModificationHandler<E> createHandler(Collection<E> coll, Object listener) {
        if (listener == null) {
            return new StandardModificationHandler();
        }
        ModificationHandlerFactory[] array = factories;
        for (int i = array.length - 1; i >= 0; --i) {
            ModificationHandler handler = array[i].createHandler(coll, listener);
            if (handler == null) continue;
            return handler;
        }
        throw new IllegalArgumentException("Unrecognised listener type: " + (listener == null ? "null" : listener.getClass().getName()));
    }

    public ModificationHandler<E> getHandler() {
        return this.handler;
    }

    public boolean add(E object) {
        boolean result = false;
        if (this.handler.preAdd(object)) {
            result = this.decorated().add(object);
            this.handler.postAdd(object, result);
        }
        return result;
    }

    public boolean addAll(Collection<? extends E> coll) {
        boolean result = false;
        if (this.handler.preAddAll(coll)) {
            result = this.decorated().addAll(coll);
            this.handler.postAddAll(coll, result);
        }
        return result;
    }

    public void clear() {
        if (this.handler.preClear()) {
            this.decorated().clear();
            this.handler.postClear();
        }
    }

    public Iterator<E> iterator() {
        return new ObservableIterator(this.decorated().iterator());
    }

    public boolean remove(Object object) {
        boolean result = false;
        if (this.handler.preRemove(object)) {
            result = this.decorated().remove(object);
            this.handler.postRemove(object, result);
        }
        return result;
    }

    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        if (this.handler.preRemoveAll(coll)) {
            result = this.decorated().removeAll(coll);
            this.handler.postRemoveAll(coll, result);
        }
        return result;
    }

    public boolean retainAll(Collection<?> coll) {
        boolean result = false;
        if (this.handler.preRetainAll(coll)) {
            result = this.decorated().retainAll(coll);
            this.handler.postRetainAll(coll, result);
        }
        return result;
    }

    protected class ObservableIterator<F>
    extends AbstractIteratorDecorator<F> {
        protected int lastIndex;
        protected F last;

        protected ObservableIterator(Iterator<F> iterator) {
            super(iterator);
            this.lastIndex = -1;
        }

        public F next() {
            this.last = super.next();
            ++this.lastIndex;
            return this.last;
        }

        public void remove() {
            if (ObservableCollection.this.handler.preRemoveIterated(this.lastIndex, this.last)) {
                this.getIterator().remove();
                ObservableCollection.this.handler.postRemoveIterated(this.lastIndex, this.last);
                --this.lastIndex;
            }
        }
    }
}

