/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.observable;

import house.intelli.core.observable.ModificationHandler;
import house.intelli.core.observable.ObservableCollection;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.iterators.AbstractListIteratorDecorator;

public class ObservableList<E>
extends ObservableCollection<E>
implements List<E> {
    private static final long serialVersionUID = 1L;

    public static <E> ObservableList<E> decorate(List<E> list) {
        return new ObservableList<E>(list, (Object)null);
    }

    public static <E> ObservableList<E> decorate(List<E> list, Object listener) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        return new ObservableList<E>(list, listener);
    }

    protected ObservableList(List<E> list, Object listener) {
        super(list, listener);
    }

    protected ObservableList(ModificationHandler<E> handler, List<E> list) {
        super(handler, list);
    }

    private List<E> getList() {
        return (List)this.decorated();
    }

    @Override
    public E get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    @Override
    public void add(int index, E object) {
        if (this.handler.preAddIndexed(index, object)) {
            this.getList().add(index, object);
            this.handler.postAddIndexed(index, object);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        boolean result = false;
        if (this.handler.preAddAllIndexed(index, coll)) {
            result = this.getList().addAll(index, coll);
            this.handler.postAddAllIndexed(index, coll, result);
        }
        return result;
    }

    @Override
    public E remove(int index) {
        E result = null;
        if (this.handler.preRemoveIndexed(index)) {
            result = this.getList().remove(index);
            this.handler.postRemoveIndexed(index, result);
        }
        return result;
    }

    @Override
    public E set(int index, E object) {
        E result = null;
        if (this.handler.preSetIndexed(index, object)) {
            result = this.getList().set(index, object);
            this.handler.postSetIndexed(index, object, result);
        }
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ObservableListIterator<E>(this.getList().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ObservableListIterator<E>(this.getList().listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> subList = this.getList().subList(fromIndex, toIndex);
        return new ObservableList<E>(subList, (Object)this.getHandler().createSubListHandler(fromIndex, toIndex));
    }

    protected class ObservableListIterator<F>
    extends AbstractListIteratorDecorator<F> {
        protected F last;

        protected ObservableListIterator(ListIterator<F> iterator) {
            super(iterator);
        }

        public F next() {
            this.last = super.next();
            return this.last;
        }

        public F previous() {
            this.last = this.getListIterator().previous();
            return this.last;
        }

        public void remove() {
            int index = this.getListIterator().previousIndex();
            if (ObservableList.this.handler.preRemoveIterated(index, this.last)) {
                this.getListIterator().remove();
                ObservableList.this.handler.postRemoveIterated(index, this.last);
            }
        }

        public void add(F object) {
            int index = this.getListIterator().nextIndex();
            if (ObservableList.this.handler.preAddIterated(index, object)) {
                this.getListIterator().add(object);
                ObservableList.this.handler.postAddIterated(index, object);
            }
        }

        public void set(F object) {
            int index = this.getListIterator().previousIndex();
            if (ObservableList.this.handler.preSetIterated(index, object, this.last)) {
                this.getListIterator().set(object);
                ObservableList.this.handler.postSetIterated(index, object, this.last);
            }
        }
    }
}

