/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.observable;

import house.intelli.core.observable.ObservableSet;
import java.util.Comparator;
import java.util.SortedSet;

public class ObservableSortedSet<E>
extends ObservableSet<E>
implements SortedSet<E> {
    private static final long serialVersionUID = 1L;

    public static <E> ObservableSortedSet<E> decorate(SortedSet<E> set) {
        return new ObservableSortedSet<E>(set, (Object)null);
    }

    public static <E> ObservableSortedSet<E> decorate(SortedSet<E> set, Object listener) {
        if (set == null) {
            throw new IllegalArgumentException("SortedSet must not be null");
        }
        return new ObservableSortedSet<E>(set, listener);
    }

    protected ObservableSortedSet(SortedSet<E> set, Object listener) {
        super(set, listener);
    }

    private SortedSet<E> getSortedSet() {
        return (SortedSet)this.decorated();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.getSortedSet().comparator();
    }

    @Override
    public E first() {
        return this.getSortedSet().first();
    }

    @Override
    public E last() {
        return this.getSortedSet().last();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> subSet = this.getSortedSet().subSet(fromElement, toElement);
        return new ObservableSortedSet<E>(subSet, (Object)this.getHandler().createSubSetHandler(fromElement, toElement));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        SortedSet<E> headSet = this.getSortedSet().headSet(toElement);
        return new ObservableSortedSet<E>(headSet, (Object)this.getHandler().createHeadSetHandler(toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet<E> tailSet = this.getSortedSet().tailSet(fromElement);
        return new ObservableSortedSet<E>(tailSet, (Object)this.getHandler().createTailSetHandler(fromElement));
    }
}

