/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.observable.standard;

import house.intelli.core.observable.ModificationEvent;
import house.intelli.core.observable.ModificationEventType;
import house.intelli.core.observable.ModificationHandler;
import house.intelli.core.observable.ObservableCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Bag;

public class StandardModificationEvent
extends ModificationEvent {
    protected final int preSize;
    protected final int index;
    protected final Object object;
    protected final int repeat;
    protected final Object previous;
    protected final ObservableCollection view;
    protected final int viewOffset;

    public StandardModificationEvent(ObservableCollection obsCollection, ModificationHandler handler, int type, int preSize, int index, Object object, int repeat, Object previous, ObservableCollection view, int viewOffset) {
        super(obsCollection, handler, type);
        this.preSize = preSize;
        this.index = index;
        this.object = object;
        this.repeat = repeat;
        this.previous = previous;
        this.view = view;
        this.viewOffset = viewOffset;
    }

    public int getChangeIndex() {
        return this.index;
    }

    public Object getChangeObject() {
        return this.object;
    }

    public Collection getChangeCollection() {
        if (this.object == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.isType(57392)) {
            if (this.object instanceof Collection) {
                return (Collection)this.object;
            }
            throw new IllegalStateException("Bulk operations must involve a Collection, but was " + this.object.getClass().getName());
        }
        return Collections.singletonList(this.object);
    }

    public int getChangeRepeat() {
        return this.repeat;
    }

    public Object getPrevious() {
        return this.previous;
    }

    public int getPreSize() {
        return this.preSize;
    }

    public ObservableCollection getView() {
        return this.view;
    }

    public boolean isView() {
        return this.view != null;
    }

    public int getViewOffset() {
        return this.viewOffset;
    }

    public boolean isTypeAdd() {
        return (this.type & 0x3F) > 0;
    }

    public boolean isTypeReduce() {
        return (this.type & 0xFF00) > 0;
    }

    public boolean isTypeChange() {
        return (this.type & 0x30000) > 0;
    }

    public boolean isTypeBulk() {
        return (this.type & 0xE030) > 0;
    }

    public boolean isType(int eventType) {
        return (this.type & eventType) > 0;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("ModificationEvent[type=");
        buf.append(ModificationEventType.toString(this.type));
        if (this.index >= 0) {
            buf.append(",index=");
            buf.append(this.index);
        }
        if (this.type != 32768) {
            buf.append(",object=");
            if (this.object instanceof List) {
                buf.append("List:size:");
                buf.append(((List)this.object).size());
            } else if (this.object instanceof Set) {
                buf.append("Set:size:");
                buf.append(((Set)this.object).size());
            } else if (this.object instanceof Bag) {
                buf.append("Bag:size:");
                buf.append(((Bag)this.object).size());
            } else if (this.object instanceof Collection) {
                buf.append("Collection:size:");
                buf.append(((Collection)this.object).size());
            } else if (this.object instanceof Map) {
                buf.append("Map:size:");
                buf.append(((Map)this.object).size());
            } else if (this.object instanceof Object[]) {
                buf.append("Array:size:");
                buf.append(((Object[])this.object).length);
            } else if (this.object == null) {
                buf.append("null");
            } else {
                buf.append(this.object.toString());
            }
        }
        buf.append(']');
        return buf.toString();
    }
}

