/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.pv;

import java.util.Objects;

public enum DeviceMode {
    BATTERY,
    LINE,
    FAULT,
    POWERED,
    STAND_BY,
    ENERGY_SAVING;


    public static DeviceMode from(String string) {
        Objects.requireNonNull(string, "string");
        if (string.length() < 1) {
            throw new IllegalArgumentException("string is empty");
        }
        char c = string.charAt(0);
        switch (c) {
            case 'B': {
                return BATTERY;
            }
            case 'L': {
                return LINE;
            }
            case 'F': {
                return FAULT;
            }
            case 'P': {
                return POWERED;
            }
            case 'S': {
                return STAND_BY;
            }
            case 'E': 
            case 'H': {
                return ENERGY_SAVING;
            }
        }
        throw new IllegalArgumentException("string represents no known DeviceMode: " + string);
    }
}

